package com.bxm.shop.wxpay.dto;

import com.bxm.shop.config.WechatConfig;
import com.bxm.shop.wxpay.WxPayUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;

/**
 * 商户向个人转账
 * @author liguang.jin
 *
 */
@XStreamAlias("xml")
public class PayPerson {
	@XStreamOmitField  
	private Logger logger = LoggerFactory.getLogger(PayPerson.class);
			
	public PayPerson(){
		
	}
	public PayPerson(String mchAppid,String mchid) {
		this.mchAppid = mchAppid;
		this.mchid = mchid;
	}
	
	@XStreamAlias("mch_appid")
	private String mchAppid; //微信分配的公众账号ID（企业号corpid即为此appId）
	@XStreamAlias("mchid")
	private String mchid;  //微信支付分配的商户号
	@XStreamAlias("device_info")
	private String deviceInfo;  //微信支付分配的终端设备号(非必须)
	@XStreamAlias("nonce_str")
	private String nonceStr;  //随机字符串，不长于32位
	@XStreamAlias("sign")
	private String sign;  
	@XStreamAlias("partner_trade_no")
	private String partnerTradeNo; //商户订单号，需保持唯一性
	@XStreamAlias("openid")
	private String openid;  //商户appid下，某用户的openid
	@XStreamAlias("check_name")
	private String checkName;  //NO_CHECK：不校验真实姓名  FORCE_CHECK：强校验真实姓名（未实名认证的用户会校验失败，无法转账）  OPTION_CHECK：针对已实名认证的用户才校验真实姓名（未实名认证用户不校验，可以转账成功）
	@XStreamAlias("re_user_name")
	private String reUserName;  //收款用户真实姓名。  如果check_name设置为FORCE_CHECK或OPTION_CHECK，则必填用户真实姓名
	@XStreamAlias("amount")
	private Integer amount; //企业付款金额，单位为分
	@XStreamAlias("desc")
	private String desc; //企业付款操作说明信息。必填。
	@XStreamAlias("spbill_create_ip")
	private String spbillCreateIp;  //调用接口的机器Ip地址

	@XStreamAlias("appid")
	private String queryAppid;
	@XStreamAlias("mch_id")
	private String queryMchid;
	
	public void createSign(WechatConfig config) throws IllegalArgumentException, IllegalAccessException, UnsupportedEncodingException {
		this.sign = WxPayUtil.createSign(this, config.getPaySecret(),true);
	}

	public String getMchAppid() {
		return mchAppid;
	}
	public void setMchAppid(String mchAppid) {
		this.mchAppid = mchAppid;
	}
	public String getMchid() {
		return mchid;
	}
	public void setMchid(String mchid) {
		this.mchid = mchid;
	}
	public String getDeviceInfo() {
		return deviceInfo;
	}
	public void setDeviceInfo(String deviceInfo) {
		this.deviceInfo = deviceInfo;
	}
	public String getNonceStr() {
		return nonceStr;
	}
	public void setNonceStr(String nonceStr) {
		this.nonceStr = nonceStr;
	}
	public String getSign() {
		return sign;
	}
	public void setSign(String sign) {
		this.sign = sign;
	}
	public String getPartnerTradeNo() {
		return partnerTradeNo;
	}
	public void setPartnerTradeNo(String partnerTradeNo) {
		this.partnerTradeNo = partnerTradeNo;
	}
	public String getOpenid() {
		return openid;
	}
	public void setOpenid(String openid) {
		this.openid = openid;
	}
	public String getReUserName() {
		return reUserName;
	}
	public void setReUserName(String reUserName) {
		this.reUserName = reUserName;
	}
	public Integer getAmount() {
		return amount;
	}
	public void setAmount(Integer amount) {
		this.amount = amount;
	}
	public String getDesc() {
		return desc;
	}
	public void setDesc(String desc) {
		this.desc = desc;
	}
	public String getSpbillCreateIp() {
		return spbillCreateIp;
	}
	public void setSpbillCreateIp(String spbillCreateIp) {
		this.spbillCreateIp = spbillCreateIp;
	}
	public String getCheckName() {
		return checkName;
	}
	public void setCheckName(String checkName) {
		this.checkName = checkName;
	}

	public String getQueryAppid() {
		return queryAppid;
	}

	public void setQueryAppid(String queryAppid) {
		this.queryAppid = queryAppid;
	}

	public String getQueryMchid() {
		return queryMchid;
	}

	public void setQueryMchid(String queryMchid) {
		this.queryMchid = queryMchid;
	}

	@Override
	public String toString() {
		return "PayPerson{" +
				"mchAppid='" + mchAppid + '\'' +
				", mchid='" + mchid + '\'' +
				", deviceInfo='" + deviceInfo + '\'' +
				", nonceStr='" + nonceStr + '\'' +
				", sign='" + sign + '\'' +
				", partnerTradeNo='" + partnerTradeNo + '\'' +
				", openid='" + openid + '\'' +
				", checkName='" + checkName + '\'' +
				", reUserName='" + reUserName + '\'' +
				", amount=" + amount +
				", desc='" + desc + '\'' +
				", spbillCreateIp='" + spbillCreateIp + '\'' +
				'}';
	}
}
