/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.jobs;

import com.bxm.shop.common.utils.ExceptionPrintUtils;
import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.integration.OrderServiceIntegration;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DeleteAbandonOrderJob {
    private static final Logger log = LoggerFactory.getLogger(DeleteAbandonOrderJob.class);
    @Autowired
    private MessageSender messageSender;
    @Autowired
    private OrderServiceIntegration orderServiceIntegration;

    @Scheduled(cron="0 0 2 * * ?")
    public void deleteAbandonOrder() {
        log.warn("-------- Start deleteAbandonOrder-------, {}");
        Long start = System.currentTimeMillis();
        OrderDto dto = new OrderDto();
        dto.setDate(DateUtils.addDays((Date)new Date(), (int)-7));
        try {
            this.orderServiceIntegration.deleteAbandonOrder(dto);
        }
        catch (Exception e) {
            Message msg = new Message();
            msg.setContent("deleteAbandonOrder Error:" + ExceptionPrintUtils.printStackTraceToString((Throwable)e));
            this.messageSender.send2(msg);
            log.error("deleteAbandonOrder error", (Throwable)e);
        }
        log.info("deleteAbandonOrder finished in {} ms", (Object)(System.currentTimeMillis() - start));
    }
}

