/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.merchant.controller;

import com.bxm.shopping.common.exception.AuthException;
import com.bxm.shopping.common.utils.RequestInfoUtils;
import com.bxm.shopping.integration.advertiser.model.AdvertiserLoginVo;
import com.bxm.shopping.merchant.interceptor.UserTokenUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseController {
    @Autowired
    protected UserTokenUtils userTokenUtils;

    public AdvertiserLoginVo getAdvertiserLoginVo() {
        String token = RequestInfoUtils.getCurrentToken();
        if (StringUtils.isBlank((String)token)) {
            throw new AuthException("token is null");
        }
        AdvertiserLoginVo userByToken = this.userTokenUtils.getUserByToken(token);
        if (null == userByToken) {
            throw new AuthException("token is invalid");
        }
        return userByToken;
    }

    public Integer getLoginAdvertiserId() {
        AdvertiserLoginVo advertiserLoginVo = this.getAdvertiserLoginVo();
        return advertiserLoginVo.getId();
    }

    public Integer getLoginVoByToken(String token) {
        if (StringUtils.isBlank((String)token)) {
            throw new RuntimeException("token is null");
        }
        AdvertiserLoginVo userByToken = this.userTokenUtils.getUserByToken(token);
        if (null == userByToken) {
            throw new RuntimeException("token is invalid");
        }
        return userByToken.getId();
    }
}

