/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.merchant.controller;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.common.enums.OrderBehaviorTypeEnum;
import com.bxm.shopping.common.enums.OrderType;
import com.bxm.shopping.common.exception.ShoppingException;
import com.bxm.shopping.integration.advertiser.AdvertiserIntegration;
import com.bxm.shopping.integration.advertiser.model.Advertiser;
import com.bxm.shopping.merchant.controller.BaseController;
import com.bxm.shopping.model.query.OrderApiDto;
import com.bxm.shopping.model.query.OrderBehaviorDto;
import com.bxm.shopping.model.query.UserOrderQuery;
import com.bxm.shopping.model.vo.ExprortOrderVo;
import com.bxm.shopping.model.vo.UserOrderVo;
import com.bxm.shopping.service.IUserOrderService;
import com.bxm.util.MD5Util;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Striped;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class OpenApiController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(OpenApiController.class);
    @Resource
    IUserOrderService orderService;
    @Autowired
    private AdvertiserIntegration advertiserIntegration;
    private static final Integer UPLOAD_ORDER_LIMIT = 500;
    private static final Striped<Lock> orderListStriped = Striped.lazyWeakLock((int)127);
    private static final Striped<Lock> behaviorStriped = Striped.lazyWeakLock((int)127);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/order/list"}, method={RequestMethod.POST}, produces={"application/json"})
    public synchronized ResponseModel<Object> orderListApi(@RequestBody OrderApiDto orderApiDto) throws Exception {
        boolean tryLock = false;
        Lock lock = null;
        if (Objects.nonNull(orderApiDto.getAdvertiserId()) && !(tryLock = (lock = (Lock)orderListStriped.get((Object)orderApiDto.getAdvertiserId().toString())).tryLock(5L, TimeUnit.SECONDS))) {
            throw new ShoppingException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        try {
            long startTime = System.currentTimeMillis();
            log.info("orderListApi request param: {}", (Object)JSONObject.toJSONString((Object)orderApiDto));
            this.checkOrderListParam(orderApiDto);
            UserOrderQuery orderQuery = this.buildOrderQuery(orderApiDto);
            List list = this.orderService.getPage(orderQuery).getRecords();
            ArrayList<ExprortOrderVo> orderVosList = new ArrayList<ExprortOrderVo>();
            for (UserOrderVo orderVo : list) {
                ExprortOrderVo exprortOrderVo = new ExprortOrderVo();
                BeanUtils.copyProperties((Object)orderVo, (Object)exprortOrderVo);
                exprortOrderVo.setOrderStatus(OrderType.getByCode((Integer)orderVo.getStatus()).getDesc());
                exprortOrderVo.setProductStyle(StringUtils.replace((String)orderVo.getProductStyle(), (String)"&", (String)" \r\n"));
                exprortOrderVo.setPayTypeName(orderVo.getPayType() == null ? null : (orderVo.getPayType() == 1 ? "\u652f\u4ed8\u5b9d" : "\u5fae\u4fe1"));
                exprortOrderVo.setPayStatusName(orderVo.getPayStatus() == null ? null : (orderVo.getPayStatus() == 0 ? "\u672a\u652f\u4ed8" : "\u5df2\u652f\u4ed8"));
                orderVosList.add(exprortOrderVo);
            }
            log.info("\u5e7f\u544a\u4e3bid:{} \u8ba2\u5355\u6570\u636eAPI\u8017\u65f6\uff1a{}ms", (Object)orderApiDto.getAdvertiserId(), (Object)(System.currentTimeMillis() - startTime));
            ResponseModel responseModel = ResponseModelFactory.SUCCESS(orderVosList);
            return responseModel;
        }
        finally {
            if (tryLock) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/order/behavior"}, method={RequestMethod.POST}, produces={"application/json"})
    public synchronized ResponseModel<Object> updateOrderBehavior(@RequestBody OrderBehaviorDto orderBehaviorDto) throws Exception {
        boolean tryLock = false;
        Lock lock = null;
        if (Objects.nonNull(orderBehaviorDto.getAdvertiserId()) && !(tryLock = (lock = (Lock)behaviorStriped.get((Object)orderBehaviorDto.getAdvertiserId().toString())).tryLock(5L, TimeUnit.SECONDS))) {
            throw new ShoppingException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        try {
            long startTime = System.currentTimeMillis();
            log.info("updateOrderBehavior request param: {}", (Object)JSONObject.toJSONString((Object)orderBehaviorDto));
            this.checkOrderBehavior(orderBehaviorDto);
            this.orderService.updateBehaviorType(orderBehaviorDto);
            log.info("\u8ba2\u5355\u53f7\uff1a{} \u8ba2\u5355\u6fc0\u6d3b\u63a5\u53e3API\u8017\u65f6\uff1a{}ms", (Object)orderBehaviorDto.getOrderNum(), (Object)(System.currentTimeMillis() - startTime));
        }
        finally {
            if (tryLock) {
                lock.unlock();
            }
        }
        return ResponseModelFactory.SUCCESS();
    }

    private void checkOrderBehavior(OrderBehaviorDto activeOrderDto) throws Exception {
        Integer advertiserId = activeOrderDto.getAdvertiserId();
        Integer behaviorType = activeOrderDto.getBehaviorType();
        String orderNum = activeOrderDto.getOrderNum();
        String sign = activeOrderDto.getSign();
        String timestamp = activeOrderDto.getTimestamp();
        Preconditions.checkArgument((advertiserId != null ? 1 : 0) != 0, (Object)"\u53c2\u6570advertiserId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)timestamp), (Object)"\u53c2\u6570timestamp\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)sign), (Object)"\u53c2\u6570sign\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)orderNum), (Object)"\u53c2\u6570orderNum\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)NumberUtils.isDigits((String)orderNum), (Object)"\u53c2\u6570orderNum\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
        Preconditions.checkArgument((null != behaviorType ? 1 : 0) != 0, (Object)"\u53c2\u6570behaviorType\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> orderNumList = Arrays.asList(orderNum.split(","));
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(orderNumList), (Object)"\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        Preconditions.checkArgument((orderNumList.size() <= UPLOAD_ORDER_LIMIT ? 1 : 0) != 0, (Object)("\u8ba2\u5355\u6570\u91cf\u8d85\u51fa\u9650\u5236\uff1a" + UPLOAD_ORDER_LIMIT));
        Boolean codeExist = OrderBehaviorTypeEnum.findCodeExist((Integer)behaviorType);
        Preconditions.checkArgument((boolean)codeExist, (Object)"\u4e0d\u5b58\u5728\u7684behaviorType");
        this.verifySign(advertiserId, sign, timestamp);
    }

    private void checkOrderListParam(OrderApiDto userOrderDto) throws Exception {
        Integer advertiserId = userOrderDto.getAdvertiserId();
        String timestamp = userOrderDto.getTimestamp();
        String sign = userOrderDto.getSign();
        Preconditions.checkArgument((advertiserId != null ? 1 : 0) != 0, (Object)"\u53c2\u6570advertiserId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)timestamp), (Object)"\u53c2\u6570timestamp\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)sign), (Object)"\u53c2\u6570sign\u4e0d\u80fd\u4e3a\u7a7a");
        this.verifySign(advertiserId, sign, timestamp);
    }

    private void verifySign(Integer advertiserId, String sign, String timestamp) throws Exception {
        Advertiser advertiser = this.advertiserIntegration.getAdvertiserById(advertiserId);
        Preconditions.checkArgument((advertiser != null ? 1 : 0) != 0, (Object)"\u8be5\u5e7f\u544a\u4e3bid\u4e0d\u5b58\u5728");
        String secretKey = advertiser.getSecretKey();
        if (StringUtils.isBlank((CharSequence)secretKey)) {
            throw new ShoppingException("Verify Service Error");
        }
        String verifySign = MD5Util.md5((String)(secretKey + timestamp));
        Preconditions.checkArgument((boolean)sign.equalsIgnoreCase(verifySign), (Object)"\u7b7e\u540dsign\u6709\u8bef,\u8bf7\u68c0\u67e5");
        log.info("advertiserId\uff1a{} \u9a8c\u8bc1\u7b7e\u540d\u6210\u529f", (Object)advertiserId);
    }

    UserOrderQuery buildOrderQuery(OrderApiDto orderApiDto) {
        UserOrderQuery orderQuery = new UserOrderQuery();
        orderQuery.setPageNum(Integer.valueOf(1));
        orderQuery.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        orderQuery.setAdvertiserId(orderApiDto.getAdvertiserId());
        orderQuery.setStartTime(orderApiDto.getStartTime());
        orderQuery.setEndTime(orderApiDto.getEndTime());
        String productId = orderApiDto.getProductId();
        if (StringUtils.isNotBlank((CharSequence)productId)) {
            List<String> productList = Arrays.asList(productId.split(","));
            orderQuery.setProductIdList(productList);
        }
        return orderQuery;
    }
}

