/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.merchant.controller;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.common.enums.OrderType;
import com.bxm.shopping.common.exception.ShoppingException;
import com.bxm.shopping.common.generator.RedisLockGenerator;
import com.bxm.shopping.common.utils.DateUtil;
import com.bxm.shopping.common.utils.EasyExcelUtil;
import com.bxm.shopping.dal.entity.UserOrder;
import com.bxm.shopping.integration.kuaidi.model.TrackInfoVo;
import com.bxm.shopping.merchant.controller.BaseController;
import com.bxm.shopping.model.query.UserOrderQuery;
import com.bxm.shopping.model.vo.ExprortOrderVo;
import com.bxm.shopping.model.vo.UserOrderVo;
import com.bxm.shopping.service.IUserOrderService;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.cache.impls.redis.DistributedRedisLock;
import com.bxm.warcar.utils.UUIDHelper;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import com.google.common.util.concurrent.Striped;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class OrderController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(OrderController.class);
    @Resource
    IUserOrderService orderService;
    @Autowired
    private DistributedRedisLock distributedRedisLock;
    private static final Striped<Lock> importStriped = Striped.lazyWeakLock((int)127);
    private static final Striped<Lock> exportStriped = Striped.lazyWeakLock((int)127);

    @RequestMapping(value={"/order/getPage"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseModel getPage(UserOrderQuery orderQuery) {
        Integer loginAdvertiserId = this.getLoginAdvertiserId();
        if (loginAdvertiserId == null) {
            return ResponseModelFactory.SUCCESS();
        }
        orderQuery.setAdvertiserId(loginAdvertiserId);
        orderQuery.setPlatform(UserOrderQuery.PLATFORM_MERCHANT);
        return ResponseModelFactory.SUCCESS((Object)this.orderService.getPage(orderQuery));
    }

    @RequestMapping(value={"/order/updateStatus"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseModel updateStatus(@RequestParam(value="id") Integer id, @RequestParam(value="status") Integer status) {
        UserOrder userOrder;
        Integer loginAdvertiserId = this.getLoginAdvertiserId();
        if (!loginAdvertiserId.equals((userOrder = (UserOrder)this.orderService.findByIdWithNotNull((Serializable)id)).getAdvertiserId())) {
            throw new ValidateException("\u64cd\u4f5c\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u8be5\u8d26\u53f7");
        }
        this.orderService.updateStatus(id, status);
        return ResponseModelFactory.SUCCESS((Object)"true");
    }

    @RequestMapping(value={"/order/export"}, method={RequestMethod.GET})
    public void export(HttpServletResponse response, HttpServletRequest request, UserOrderQuery orderQuery) {
        long startTime = System.currentTimeMillis();
        orderQuery.setPageNum(Integer.valueOf(1));
        orderQuery.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        orderQuery.setPlatform(UserOrderQuery.PLATFORM_MERCHANT);
        Integer loginAdvertiserId = this.getLoginVoByToken(orderQuery.getToken());
        if (loginAdvertiserId == null) {
            return;
        }
        Lock lock = (Lock)exportStriped.get((Object)loginAdvertiserId.toString());
        boolean tryLock = false;
        try {
            tryLock = lock.tryLock(10L, TimeUnit.SECONDS);
            if (!tryLock) {
                return;
            }
            orderQuery.setAdvertiserId(loginAdvertiserId);
            List list = this.orderService.getPage(orderQuery).getRecords();
            String fileName = DateUtil.dateTo81String((Date)new Date()) + "\u8ba2\u5355";
            ArrayList<ExprortOrderVo> exprortOrderVosList = new ArrayList<ExprortOrderVo>();
            for (UserOrderVo orderVo : list) {
                ExprortOrderVo exprortOrderVo = new ExprortOrderVo();
                BeanUtils.copyProperties((Object)orderVo, (Object)exprortOrderVo);
                exprortOrderVo.setOrderStatus(OrderType.getByCode((Integer)orderVo.getStatus()).getDesc());
                exprortOrderVo.setProductStyle(StringUtils.replace((String)orderVo.getProductStyle(), (String)"&", (String)" \r\n"));
                exprortOrderVo.setPayTypeName(orderVo.getPayType() == null ? null : (orderVo.getPayType() == 1 ? "\u652f\u4ed8\u5b9d" : "\u5fae\u4fe1"));
                exprortOrderVo.setPayStatusName(orderVo.getPayStatus() == null ? null : (orderVo.getPayStatus() == 0 ? "\u672a\u652f\u4ed8" : "\u5df2\u652f\u4ed8"));
                exprortOrderVosList.add(exprortOrderVo);
            }
            EasyExcelUtil.write((HttpServletResponse)response, (String)fileName, ExprortOrderVo.class, exprortOrderVosList);
            log.info("\u5e7f\u544a\u4e3bid:{} \u5bfc\u51fa\u8ba2\u5355\u8017\u65f6\uff1a{}ms", (Object)loginAdvertiserId, (Object)(System.currentTimeMillis() - startTime));
        }
        catch (InterruptedException e) {
            log.error("\u5bfc\u51fa\u8ba2\u5355 try lock interrupted", (Throwable)e);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u8ba2\u5355\u6570\u636e\u5f02\u5e38\uff0crequest: {}, orderQuery:{}", (Object)JSONObject.toJSONString((Object)request), (Object)JSONObject.toJSONString((Object)orderQuery));
            throw e;
        }
        finally {
            if (tryLock) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/order/importOrder"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseModel importOrder(@RequestParam(value="file") MultipartFile file, @RequestParam(value="company") String company) {
        Integer loginAdvertiserId = this.getLoginAdvertiserId();
        List orderVos = null;
        try {
            orderVos = EasyExcelUtil.read((InputStream)file.getInputStream(), ExprortOrderVo.class);
        }
        catch (IOException e) {
            throw new ShoppingException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (CollectionUtils.isEmpty((Collection)orderVos)) {
            throw new ShoppingException("\u4e0d\u80fd\u5bfc\u5165\u7a7a\u6587\u4ef6");
        }
        Lock lock = (Lock)importStriped.get((Object)loginAdvertiserId.toString());
        boolean tryLock = false;
        try {
            tryLock = lock.tryLock();
            if (!tryLock) {
                ResponseModel responseModel = ResponseModelFactory.FAILED500((String)"\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                return responseModel;
            }
            ResponseModel responseModel = ResponseModelFactory.SUCCESS((Object)this.orderService.importOrder(orderVos, company, loginAdvertiserId));
            return responseModel;
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u53d1\u8d27\u5f02\u5e38", (Throwable)e);
            ResponseModel responseModel = ResponseModelFactory.FAILED500();
            return responseModel;
        }
        finally {
            if (tryLock) {
                lock.unlock();
            }
        }
    }

    @RequestMapping(value={"/order/getOrderInfo"}, method={RequestMethod.GET})
    public ResponseModel getOrderInfo(Integer id) {
        return ResponseModelFactory.SUCCESS((Object)this.orderService.getOrderInfo(id));
    }

    @RequestMapping(value={"/order/batchCancel"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseModel batchCancel(@RequestParam(value="file") MultipartFile file) {
        Integer loginAdvertiserId = this.getLoginAdvertiserId();
        List orderVos = null;
        try {
            orderVos = EasyExcelUtil.read((InputStream)file.getInputStream(), ExprortOrderVo.class);
        }
        catch (IOException e) {
            throw new ShoppingException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (CollectionUtils.isEmpty((Collection)orderVos)) {
            throw new ShoppingException("\u4e0d\u80fd\u5bfc\u5165\u7a7a\u6587\u4ef6");
        }
        return ResponseModelFactory.SUCCESS((Object)this.orderService.batchCancel(orderVos, loginAdvertiserId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/order/updateSendStatus"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseModel updateSendStatus(@RequestParam(value="id") Integer id, @RequestParam(value="trackingNum") String trackingNum, @RequestParam(value="company") String company) {
        UserOrder userOrder;
        Integer loginAdvertiserId = this.getLoginAdvertiserId();
        if (!loginAdvertiserId.equals((userOrder = (UserOrder)this.orderService.findByIdWithNotNull((Serializable)id)).getAdvertiserId())) {
            throw new ValidateException("\u64cd\u4f5c\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u8be5\u8d26\u53f7");
        }
        String rid = UUIDHelper.generate();
        try {
            boolean tryLock = this.distributedRedisLock.tryLock(RedisLockGenerator.getSendUpdate((Integer)id).generateKey(), rid);
            if (!tryLock) {
                ResponseModel responseModel = ResponseModelFactory.FAILED500((String)"\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                return responseModel;
            }
            this.orderService.updateSendStatus(id, trackingNum, company);
        }
        catch (Exception exception) {
        }
        finally {
            this.distributedRedisLock.unLock(RedisLockGenerator.getSendUpdate((Integer)id).generateKey(), rid);
        }
        return ResponseModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/order/getTrackInfo"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseModel getTrackInfo(@RequestParam(value="id") Integer id) {
        UserOrder userOrder;
        Integer loginAdvertiserId = this.getLoginAdvertiserId();
        if (!loginAdvertiserId.equals((userOrder = (UserOrder)this.orderService.findByIdWithNotNull((Serializable)id)).getAdvertiserId())) {
            throw new ValidateException("\u64cd\u4f5c\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u8be5\u8d26\u53f7");
        }
        TrackInfoVo vo = this.orderService.getTrackInfo(id);
        return ResponseModelFactory.SUCCESS((Object)vo);
    }
}

