/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.merchant.controller;

import com.bxm.shopping.common.generator.MerchantKeyGenerator;
import com.bxm.shopping.integration.advertiser.model.AdvertiserLoginVo;
import com.bxm.shopping.merchant.interceptor.UserTokenUtils;
import com.bxm.shopping.model.dto.MerchantLoginDto;
import com.bxm.shopping.service.AdvertiserUserService;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController {
    @Autowired
    private AdvertiserUserService advertiserUserService;
    @Autowired
    private JedisFetcher jedisFetcher;
    @Autowired
    private JedisUpdater jedisUpdater;
    @Autowired
    private UserTokenUtils userTokenUtils;

    @RequestMapping(value={"/login"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseModel login(@Validated MerchantLoginDto merchantLoginDto) {
        KeyGenerator keyGenerator = MerchantKeyGenerator.getImgCaptcha((String)merchantLoginDto.getUuid());
        String captchaCache = (String)this.jedisFetcher.fetch(keyGenerator, String.class);
        if (StringUtils.isBlank((String)captchaCache)) {
            return ResponseModelFactory.FAILED((Integer)400, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.jedisUpdater.remove(keyGenerator);
        if (!captchaCache.equalsIgnoreCase(merchantLoginDto.getImgCaptcha())) {
            return ResponseModelFactory.FAILED((Integer)400, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        AdvertiserLoginVo loginVo = this.advertiserUserService.login(merchantLoginDto);
        return ResponseModelFactory.SUCCESS((Object)loginVo);
    }

    @RequestMapping(value={"/getImgCaptcha"}, method={RequestMethod.GET})
    public void getImgCaptcha(@RequestParam(name="uuid") String uuid) {
        this.advertiserUserService.getImgCaptcha(uuid);
    }

    @RequestMapping(value={"/quit"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseModel quit() {
        this.userTokenUtils.removeUserToken();
        return ResponseModelFactory.SUCCESS();
    }
}

