/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.merchant.global;

import com.bxm.shopping.common.exception.AuthException;
import com.bxm.shopping.common.exception.ShoppingException;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={UnsupportedOperationException.class})
    @ResponseBody
    public ResponseModel<String> unsupportedOperation() {
        return ResponseModelFactory.FAILED((Integer)404, (String)"");
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseBody
    public ResponseModel<String> illegalStateException(Throwable throwable) {
        return ResponseModelFactory.FAILED((Integer)403, (String)throwable.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public ResponseModel<String> illegalArgument(Throwable throwable) {
        return ResponseModelFactory.FAILED((Integer)400, (String)throwable.getMessage());
    }

    @ExceptionHandler(value={ValidateException.class})
    @ResponseBody
    public ResponseModel<String> validateException(Throwable throwable) {
        return ResponseModelFactory.FAILED500((String)throwable.getMessage());
    }

    @ExceptionHandler(value={AuthException.class})
    @ResponseBody
    public ResponseModel<String> AuthException(Throwable throwable) {
        return ResponseModelFactory.FAILED((Integer)401, (String)throwable.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseModel<String> HttpRequestMethodNotSupportedException(Throwable throwable) {
        return ResponseModelFactory.FAILED((Integer)405, (String)throwable.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseModel<String> HttpMessageNotReadableException(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        return ResponseModelFactory.FAILED((Integer)400, (String)"\u8bf7\u68c0\u67e5\u53c2\u6570");
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public ResponseModel<String> HttpMediaTypeNotSupportedException(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        return ResponseModelFactory.FAILED((Integer)400, (String)"\u8bf7\u68c0\u67e5\u8bf7\u6c42\u6570\u636e\u683c\u5f0f");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseModel<String> exception(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        return ResponseModelFactory.FAILED500((String)"Internal Server Error");
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public ResponseModel<String> BindException(Throwable throwable) {
        String[] msg = throwable.getMessage().split(";");
        String finalmsg = msg[msg.length - 1].replace("default", "").replace("message", "").replace("[", "").replace("]", "");
        return ResponseModelFactory.FAILED500((String)finalmsg);
    }

    @ExceptionHandler(value={ShoppingException.class})
    @ResponseBody
    public ResponseModel handleGatherException(Exception e) {
        return ResponseModelFactory.FAILED500((String)e.getMessage());
    }
}

