/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.merchant.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.integration.advertiser.model.AdvertiserLoginVo;
import com.bxm.shopping.merchant.interceptor.UserTokenUtils;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class AuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    @Autowired
    private UserTokenUtils userTokenUtils;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        String token = request.getHeader("token");
        if (StringUtils.isBlank((String)token)) {
            AuthInterceptor.noAuthorityAction(response);
            return false;
        }
        AdvertiserLoginVo user = this.userTokenUtils.getUserByToken(token);
        if (null == user) {
            AuthInterceptor.noAuthorityAction(response);
            return false;
        }
        return true;
    }

    public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, ModelAndView modelAndView) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        String token = request.getHeader("token");
        if (StringUtils.isBlank((String)token)) {
            AuthInterceptor.noAuthorityAction(response);
        }
        try {
            this.userTokenUtils.expireUserToken(token);
        }
        catch (Exception e) {
            log.error("expire user token fail \uff01", (Throwable)e);
        }
    }

    private static void noAuthorityAction(HttpServletResponse response) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.print(JSONObject.toJSON((Object)ResponseModelFactory.FAILED((Integer)401, (String)"\u767b\u5f55\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55")));
        out.flush();
    }
}

