/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.merchant.interceptor;

import com.bxm.shopping.common.generator.MerchantKeyGenerator;
import com.bxm.shopping.common.utils.RequestInfoUtils;
import com.bxm.shopping.integration.advertiser.model.AdvertiserLoginVo;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class UserTokenUtils {
    @Autowired
    private JedisUpdater jedisUpdater;
    @Autowired
    private JedisFetcher jedisFetcher;
    private Integer TOKEN_EXTEND_TIME = 7200;

    public void expireUserToken(String token) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)token)) {
            return;
        }
        JedisPool jedisPool = (JedisPool)this.jedisFetcher.getClientOriginal();
        try (Jedis jedis = jedisPool.getResource();){
            jedis.expire(MerchantKeyGenerator.getToken((String)token).generateKey(), this.TOKEN_EXTEND_TIME.intValue());
        }
    }

    public AdvertiserLoginVo getUserByToken(String token) {
        if (StringUtils.isBlank((String)token)) {
            return null;
        }
        return (AdvertiserLoginVo)this.jedisFetcher.fetch(MerchantKeyGenerator.getToken((String)token), AdvertiserLoginVo.class);
    }

    public void removeUserToken() {
        String token = RequestInfoUtils.getCurrentToken();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)token)) {
            return;
        }
        this.jedisUpdater.remove(MerchantKeyGenerator.getToken((String)token));
    }
}

