/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.deal.dal.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.cache.RedisClient;
import com.bxm.spider.cache.constant.IdKeyConstant;
import com.bxm.spider.constant.exception.BaseRunException;
import com.bxm.spider.deal.common.utils.StringHelp;
import com.bxm.spider.deal.dal.mapper.NewsMapper;
import com.bxm.spider.deal.dal.service.NewsContentService;
import com.bxm.spider.deal.dal.service.NewsService;
import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.spider.deal.model.dao.News;
import com.bxm.spider.deal.model.dao.NewsContent;
import com.bxm.spider.utils.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewsServiceImpl
extends ServiceImpl<NewsMapper, News>
implements NewsService {
    private static final Logger LOG = LoggerFactory.getLogger(NewsServiceImpl.class);
    @Autowired
    private NewsMapper newsMapper;
    @Autowired
    private NewsContentService newsContentService;
    @Autowired
    private RedisClient redisClient;

    @Override
    public News findNewsByUrl(String url) {
        return this.newsMapper.findNewsByUrl(StringHelp.geHashCodeModTen((String)url), url.hashCode());
    }

    @Override
    public int insertNews(News news) {
        news.setSuffix(StringHelp.geHashCodeModTen((String)news.getUrl()));
        Long id = this.redisClient.hincrByOne(IdKeyConstant.getPrimaryId(), "NEWS");
        if (null == id) {
            id = StringHelp.getUUIDHashCode((int)14);
        }
        news.setId(Long.valueOf(id * 10L + Long.parseLong(news.getSuffix())));
        return this.newsMapper.insertReturnId(news);
    }

    @Override
    public int updateNewsById(News news) {
        if (StringUtils.isBlank((CharSequence)news.getSuffix())) {
            news.setSuffix(StringHelp.geHashCodeModTen((String)news.getUrl()));
        }
        return this.newsMapper.updateNewsById(news);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BaseRunException.class}, timeout=120)
    public int insertNewsAndContent(News news, NewsContent newsContent) {
        if (StringUtils.isBlank((CharSequence)newsContent.getContent())) {
            throw new BaseRunException("[save data]news content is null,the url is " + news.getUrl());
        }
        int i = 0;
        News newsOld = this.findNewsByUrl(news.getUrl());
        news.setUrlCode(Integer.valueOf(news.getUrl().hashCode()));
        news.setModifyTime(new Date());
        if (null == newsOld) {
            i = this.insertNews(news);
            if (null == news.getId()) {
                throw new BaseRunException("the news id is null when save news,so can't save news content the url is " + news.getUrl());
            }
            newsContent.setId(news.getId());
            i += this.newsContentService.insert(news.getUrl(), newsContent);
        } else {
            news.setId(newsOld.getId());
            if (2 == newsOld.getStatus()) {
                news.setStatus(Integer.valueOf(1));
            } else {
                news.setStatus(newsOld.getStatus());
            }
            i = this.updateNewsById(news);
            newsContent.setId(newsOld.getId());
            i += this.newsContentService.updateById(news.getUrl(), newsContent);
        }
        return i;
    }

    @Override
    public List<Map<String, String>> findNewsByModifyTime(int amount) {
        Date modifyTime = DateUtils.addField((Date)new Date(), (int)6, (int)amount);
        List<Map<String, String>> newsList = this.newsMapper.findNewsByModifyTime(modifyTime);
        return newsList;
    }

    @Override
    public Map<String, String> findNewsById(Long id, String suffix) {
        return this.newsMapper.findNewsById(id, suffix);
    }

    @Override
    public List<ContentVo> listContent(ContentDto contentDto) {
        return this.newsMapper.listContent(contentDto);
    }
}

