/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.deal.dal.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.constant.exception.BaseRunException;
import com.bxm.spider.deal.dal.mapper.NewsWechatMapper;
import com.bxm.spider.deal.dal.service.NewsWeChatContentService;
import com.bxm.spider.deal.dal.service.NewsWeChatService;
import com.bxm.spider.deal.dal.utils.IdHelps;
import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.model.dao.NewsWechat;
import com.bxm.spider.deal.model.dao.NewsWechatContent;
import com.bxm.spider.utils.DateUtils;
import com.bxm.warcar.utils.DateHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewsWeChatServiceImpl
extends ServiceImpl<NewsWechatMapper, NewsWechat>
implements NewsWeChatService {
    @Autowired
    private NewsWeChatContentService newsWechatContentService;
    @Autowired
    private NewsWechatMapper newsWechatMapper;
    @Autowired
    private IdHelps idHelps;

    @Override
    public NewsWechat findByPmTitle(String wechatPm, String title) {
        NewsWechat newsWechat = (NewsWechat)this.selectOne(new EntityWrapper().eq("wechat_mp", (Object)wechatPm).eq("title", (Object)title));
        return newsWechat;
    }

    @Override
    public boolean insertWechat(NewsWechat newsWechat) {
        return this.insert(newsWechat);
    }

    @Override
    public boolean updateWechatById(NewsWechat newsWechat) {
        return this.updateById(newsWechat);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BaseRunException.class}, timeout=120)
    public boolean insertNewsAndContent(NewsWechat newsWechat, NewsWechatContent newsWechatContent) {
        if (StringUtils.isBlank((CharSequence)newsWechatContent.getContent())) {
            throw new BaseRunException("[save data]news wechat content is null,the wechat pm is " + newsWechat.getWechatMp() + " title is " + newsWechat.getTitle());
        }
        NewsWechat newsWechatOld = this.findByPmTitle(newsWechat.getWechatMp(), newsWechat.getTitle());
        newsWechat.setModifyTime(new Date());
        if (newsWechatOld == null) {
            long id = this.idHelps.getId("WECHAT");
            newsWechat.setId(Long.valueOf(id));
            this.insertWechat(newsWechat);
            newsWechatContent.setId(Long.valueOf(id));
            this.newsWechatContentService.insert(newsWechatContent);
        } else {
            newsWechat.setId(newsWechatOld.getId());
            if (2 == newsWechatOld.getStatus()) {
                newsWechat.setStatus(Integer.valueOf(1));
            } else {
                newsWechat.setStatus(newsWechatOld.getStatus());
            }
            this.updateWechatById(newsWechat);
            newsWechatContent.setId(newsWechatOld.getId());
            this.newsWechatContentService.updateById(newsWechatContent);
        }
        return true;
    }

    @Override
    public List<Map<String, String>> findNewsByModifyTime(int amount) {
        EntityWrapper wrapperWeChat = new EntityWrapper();
        wrapperWeChat.ge("modify_time", (Object)DateUtils.addField((Date)new Date(), (int)6, (int)amount));
        List weChatNews = this.selectList((Wrapper)wrapperWeChat);
        if (CollectionUtils.isEmpty((Collection)weChatNews)) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (NewsWechat newsWechat : weChatNews) {
            HashMap map = Maps.newHashMap();
            NewsWechatContent content = (NewsWechatContent)this.newsWechatContentService.selectById(newsWechat.getId());
            map.put("url", newsWechat.getWechatMp() + "->" + newsWechat.getRegion());
            map.put("title", newsWechat.getTitle());
            map.put("content", content.getContent());
            map.put("modify_time", DateHelper.convertDateToString((Date)newsWechat.getModifyTime(), (String)"yyyyMMdd"));
            result.add(map);
        }
        return result;
    }

    @Override
    public Map<String, String> findNewsById(Long id) {
        HashMap result = Maps.newHashMap();
        NewsWechat newsWechat = (NewsWechat)this.selectById(id);
        NewsWechatContent content = (NewsWechatContent)this.newsWechatContentService.selectById(id);
        if (null != newsWechat && null != content) {
            result.put("url", newsWechat.getWechatMp() + "->" + newsWechat.getRegion());
            result.put("title", newsWechat.getTitle());
            result.put("content", content.getContent());
            result.put("modify_time", DateHelper.convertDateToString((Date)newsWechat.getModifyTime(), (String)"yyyyMMdd"));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> findList(ContentDto contentDto) {
        return this.newsWechatMapper.findList(contentDto);
    }
}

