/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.deal.dal.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.deal.dal.mapper.UrlRulerMapper;
import com.bxm.spider.deal.dal.service.UrlRulerService;
import com.bxm.spider.deal.model.dao.UrlRuler;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UrlRulerServiceImpl
extends ServiceImpl<UrlRulerMapper, UrlRuler>
implements UrlRulerService {
    private static final Logger LOG = LoggerFactory.getLogger(UrlRulerServiceImpl.class);

    @Override
    public Map<String, UrlRuler> getListRulerBySite(String site) {
        List<UrlRuler> rulerList = this.getRulerBySite(site);
        if (null == rulerList || rulerList.size() == 0) {
            LOG.error("the url ruler is null,the site is {} ===", (Object)site);
            return null;
        }
        HashMap rulerMap = Maps.newHashMap();
        for (UrlRuler ruler : rulerList) {
            rulerMap.put(ruler.getKeyword(), ruler);
        }
        String parentSite = rulerList.get(0).getParentSite();
        if (StringUtils.isNotBlank((CharSequence)parentSite)) {
            List<UrlRuler> parentList = this.getRulerBySite(parentSite);
            for (UrlRuler parent : parentList) {
                if (rulerMap.containsKey(parent.getKeyword())) continue;
                rulerMap.put(parent.getKeyword(), parent);
            }
        }
        return rulerMap;
    }

    @Override
    public Map<String, UrlRuler> getDetailRuler(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            LOG.error("the detail url is null,can't get rulers ===");
            return null;
        }
        List<UrlRuler> rulerList = this.getRulerByNotIn("keyword", "url_list", "url_next_list", "url_detail");
        HashMap rulerMap = Maps.newHashMap();
        String ruleKey = "";
        for (UrlRuler urlRuler : rulerList) {
            if (url.indexOf(urlRuler.getSite()) <= -1) continue;
            if (urlRuler.getSite().length() > ruleKey.length()) {
                ruleKey = urlRuler.getSite();
            }
            if (rulerMap.containsKey(urlRuler.getSite())) {
                ((List)rulerMap.get(urlRuler.getSite())).add(urlRuler);
                continue;
            }
            ArrayList rulers = Lists.newArrayList();
            rulers.add(urlRuler);
            rulerMap.put(urlRuler.getSite(), rulers);
        }
        List resultList = (List)rulerMap.get(ruleKey);
        if (null == resultList || resultList.size() == 0) {
            return null;
        }
        HashMap resultMap = Maps.newHashMap();
        for (UrlRuler urlRuler : resultList) {
            resultMap.put(urlRuler.getKeyword(), urlRuler);
        }
        String parentSite = ((UrlRuler)resultList.get(0)).getParentSite();
        if (StringUtils.isNotBlank((CharSequence)parentSite)) {
            List<UrlRuler> parentList = this.getRulerBySite(parentSite);
            for (UrlRuler parent : parentList) {
                if (resultMap.containsKey(parent.getKeyword())) continue;
                resultMap.put(parent.getKeyword(), parent);
            }
        }
        rulerList = null;
        return resultMap;
    }

    @Override
    public UrlRuler getRulerByKeyWord(String url, String keyWord) {
        Map<String, UrlRuler> map = this.getListRulerBySite(url);
        if (null != map && map.containsKey(keyWord)) {
            return map.get(keyWord);
        }
        return null;
    }

    @Override
    public List<UrlRuler> getRulerByNotIn(String column, Object ... value) {
        EntityWrapper wrapper = new EntityWrapper();
        wrapper.notIn(column, value);
        return this.selectList((Wrapper)wrapper);
    }

    @Override
    public List<UrlRuler> getRulerBySite(String site) {
        EntityWrapper wrapper = new EntityWrapper();
        if (StringUtils.isNotBlank((CharSequence)site)) {
            wrapper.eq("site", (Object)site);
        }
        return this.selectList((Wrapper)wrapper);
    }
}

