/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.deal.dal.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.cache.RedisClient;
import com.bxm.spider.cache.constant.IdKeyConstant;
import com.bxm.spider.constant.exception.BaseRunException;
import com.bxm.spider.deal.common.utils.StringHelp;
import com.bxm.spider.deal.dal.mapper.CommentMapper;
import com.bxm.spider.deal.dal.mapper.VideoMapper;
import com.bxm.spider.deal.dal.service.VideoService;
import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.spider.deal.model.dao.Comment;
import com.bxm.spider.deal.model.dao.Video;
import com.bxm.spider.deal.model.dto.VideoCommentDto;
import com.bxm.spider.deal.model.dto.VideoDto;
import com.bxm.spider.utils.UploadImgUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VideoServiceImpl
extends ServiceImpl<VideoMapper, Video>
implements VideoService {
    private final Logger LOG = LoggerFactory.getLogger(VideoServiceImpl.class);
    @Autowired
    private CommentMapper commentMapper;
    @Autowired
    private VideoMapper videoMapper;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private UploadImgUtil uploadImgUtil;

    @Override
    public Video findVideoByVideoId(String videoId) {
        Video video = new Video();
        video.setUrlCode(Integer.valueOf(videoId.hashCode()));
        return (Video)this.videoMapper.selectOne(video);
    }

    @Override
    public int saveVideo(VideoDto videoDto) {
        if (null == videoDto.getVideo_url() || StringUtils.isBlank((CharSequence)videoDto.getVideo_url())) {
            throw new BaseRunException("the detailUrl is null");
        }
        Video video = new Video();
        Long id = this.redisClient.hincrByOne(IdKeyConstant.getPrimaryId(), "VIDEO");
        if (null == id) {
            id = StringHelp.getUUIDHashCode((int)16);
        }
        videoDto.setId(id);
        video.setId(id);
        video.setUrlCode(Integer.valueOf(videoDto.getVideo_id().hashCode()));
        this.setVideoValue(video, videoDto);
        return this.videoMapper.insert(video);
    }

    private void setVideoValue(Video video, VideoDto videoDto) {
        String ossUrl;
        video.setModifyTime(new Date());
        if (StringUtils.isNotBlank((CharSequence)videoDto.getNickname())) {
            video.setNickname(videoDto.getNickname().trim());
        }
        if (StringUtils.isNotBlank((CharSequence)videoDto.getDesc())) {
            video.setTitle(videoDto.getDesc().trim());
        }
        if (StringUtils.isNotBlank((CharSequence)videoDto.getVideo_id())) {
            video.setVideoId(videoDto.getVideo_id());
        }
        if (StringUtils.isNotBlank((CharSequence)videoDto.getAvatar())) {
            try {
                ossUrl = this.uploadImgUtil.getOSSUrl(videoDto.getAvatar().trim(), videoDto.getSerialNum());
                if (StringUtils.isNotBlank((CharSequence)ossUrl)) {
                    video.setAuthorImageUrl(ossUrl);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)videoDto.getVideo_img())) {
            try {
                ossUrl = this.uploadImgUtil.getOSSUrl(videoDto.getVideo_img().trim(), videoDto.getSerialNum());
                if (StringUtils.isNotBlank((CharSequence)ossUrl)) {
                    video.setVideoImageUrl(ossUrl);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)videoDto.getVideo_url())) {
            video.setVideoUrl(videoDto.getVideo_url());
        }
        if (StringUtils.isNotBlank((CharSequence)videoDto.getSource_url())) {
            video.setUrl(videoDto.getSource_url());
        }
        if (null != videoDto.getZan()) {
            video.setZan(videoDto.getZan());
        }
        if (StringUtils.isNotBlank((CharSequence)videoDto.getChannel())) {
            video.setChannel(videoDto.getChannel());
        }
        if (StringUtils.isNotBlank((CharSequence)videoDto.getSource())) {
            video.setSource(videoDto.getSource());
        }
    }

    @Override
    public int updateVideo(Video video, VideoDto videoDto) {
        this.setVideoValue(video, videoDto);
        video.setStatus(Integer.valueOf(1));
        return this.videoMapper.updateById(video);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BaseRunException.class}, timeout=120)
    public void persistVideo(VideoDto videoDto) {
        long start = System.currentTimeMillis();
        Video video = this.findVideoByVideoId(videoDto.getVideo_id());
        if (null == video) {
            int i = this.saveVideo(videoDto);
            if (i != 1) {
                throw new BaseRunException("save video failed" + videoDto);
            }
            List commentDtoList = videoDto.getComments();
            if (null != commentDtoList) {
                ArrayList comments = Lists.newArrayList();
                for (VideoCommentDto commentDto : commentDtoList) {
                    Comment comment = new Comment();
                    comment.setSourceId(videoDto.getId());
                    if (StringUtils.isNotBlank((CharSequence)videoDto.getImgUlrPrefix())) {
                        commentDto.setAvatar(videoDto.getImgUlrPrefix() + commentDto.getAvatar());
                    }
                    try {
                        String ossUrl = this.uploadImgUtil.getOSSUrl(commentDto.getAvatar(), videoDto.getSerialNum());
                        if (StringUtils.isNotBlank((CharSequence)ossUrl)) {
                            comment.setImgUrl(ossUrl);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    comment.setNickname(commentDto.getNickname());
                    comment.setContent(commentDto.getText());
                    comment.setTime(commentDto.getCreate_time());
                    comment.setZan(commentDto.getZan());
                    comment.setModifyTime(new Date());
                    comments.add(comment);
                }
                if (null != comments && comments.size() > 0) {
                    i = this.commentMapper.insertBath(comments);
                }
            }
            this.LOG.info("\u3010\u4fdd\u5b58\u5c0f\u89c6\u9891\u7ed3\u675f\u3011url:{},id:{},nickname:{},spend time {}ms", new Object[]{videoDto.getVideo_url(), videoDto.getId(), videoDto.getNickname(), System.currentTimeMillis() - start});
        } else if (2 == video.getStatus()) {
            int i = this.updateVideo(video, videoDto);
            this.LOG.info("\u3010\u4fee\u6539\u5c0f\u89c6\u9891\u7ed3\u675f\u3011url:{},id:{},nickname:{},spend time {}ms", new Object[]{videoDto.getVideo_url(), videoDto.getId(), videoDto.getNickname(), System.currentTimeMillis() - start});
        } else {
            this.LOG.info("\u3010\u5c0f\u89c6\u9891\u5df2\u5b58\u5728\u3011url:{},id:{},nickname:{}", new Object[]{videoDto.getVideo_url(), videoDto.getId(), videoDto.getNickname()});
        }
    }

    @Override
    public List<ContentVo> findVideoList(ContentDto contentDto) {
        EntityWrapper wrapper = new EntityWrapper();
        List videos = this.selectList((Wrapper)wrapper);
        ArrayList list = Lists.newArrayList();
        if (null != videos) {
            for (Video video : videos) {
                ContentVo contentVo = new ContentVo();
                contentVo.setChannel(video.getChannel());
                contentVo.setContent(video.getVideoUrl());
                contentVo.setDateTime(video.getModifyTime());
                contentVo.setDeployTime(video.getCreateTime());
                contentVo.setId(video.getId());
                contentVo.setImgUrl(video.getVideoImageUrl());
                contentVo.setSource(video.getSource());
                contentVo.setStatus(video.getStatus());
                contentVo.setTitle(StringUtils.isBlank((CharSequence)video.getDesc()) ? video.getTitle() : video.getDesc());
                contentVo.setUrl(video.getUrl());
                list.add(contentVo);
            }
        }
        return list;
    }
}

