package com.bxm.spider.deal.dal.mapper;

import com.bxm.spider.deal.model.dao.WechatNews;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Map;

/**
 * <p>
 * 爬取微信新闻表(分表) Mapper 接口
 * </p>
 *
 * @author stephen
 * @since 2019-01-03
 */
@Repository
public interface WechatNewsMapper extends MultiPageMapper<WechatNews> {

    /**
     * 插入数据
     * @param news
     * @return
     */
    int insertReturnId(WechatNews news);

    /**
     * 更新数据
     * @param news
     * @return
     */
    int updateNewsById(WechatNews news);

    /**
     * 根据url查询数据
     * @param suffix
     * @param titleCode
     * @return
     */
    WechatNews findNewsByTitle(@Param("suffix") String suffix, @Param("titleCode") Integer titleCode);

    /**
     * 根据id查询数据
     * @param id
     * @param suffix
     * @return
     */
    Map<String, String> findNewsById(@Param("id") Long id, @Param("suffix") String suffix);

}
