package com.bxm.spider.deal.dal.service;

import com.baomidou.mybatisplus.service.IService;
import com.bxm.spider.deal.model.dao.UrlRuler;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 过滤规则表 服务类
 * </p>
 *
 * @author JandMin
 * @since 2018-10-16
 */
public interface UrlRulerService extends IService<UrlRuler> {
    /**
     * 根据 url 站点获取规则
     */
    List<UrlRuler> getRulerBySiteType(String site, Short type);

    /**
     * 获取所有详情url 的规则
     */
    List<UrlRuler> getRulerByType(Short type);

    /**
     * 获取列表 url 规则（根据流水号）
     */
    Map<String, UrlRuler> getMapRulerBySiteType(String site, Short type);

    /**
     * 获取详情 规则
     */
    Map<String, UrlRuler> getRulerByUrl(String url, Short type);

    /**
     * 根据具体的keyWord获取规则
     */
    UrlRuler getRulerByKeyWord(String site, String keyWord);
}
