package com.bxm.spider.deal.dal.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.deal.dal.mapper.NewsCommentMapper;
import com.bxm.spider.deal.dal.service.NewsCommentService;
import com.bxm.spider.deal.model.dao.NewsComment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 新闻评论表 服务实现类
 * </p>
 *
 * @author JandMin
 * @since 2019-03-04
 */
@Service
public class NewsCommentServiceImpl extends ServiceImpl<NewsCommentMapper, NewsComment> implements NewsCommentService {
    @Autowired
    private NewsCommentMapper newsCommentMapper;

    @Override
    public Integer batchInsert(List<NewsComment> newsCommentList) {
        if(null == newsCommentList || newsCommentList.size() == 0){
            return null;
        }
        String suffix = newsCommentList.get(0).getSuffix();
        return newsCommentMapper.insertBatch(suffix,newsCommentList);
    }
}
