package com.bxm.spider.deal.dal.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.deal.dal.mapper.UrlRulerMapper;
import com.bxm.spider.deal.dal.service.UrlRulerService;
import com.bxm.spider.deal.model.dao.UrlRuler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 过滤规则表 服务实现类
 * </p>
 *
 * @author JandMin
 * @since 2018-10-16
 */
@Service
public class UrlRulerServiceImpl extends ServiceImpl<UrlRulerMapper, UrlRuler> implements UrlRulerService {
    private static final Logger LOG = LoggerFactory.getLogger(UrlRulerServiceImpl.class);

    @Override
    public Map<String, UrlRuler> getMapRulerBySiteType(String site, Short type) {

        // 获取站点规则
        List<UrlRuler> rulerList = getRulerBySiteType(site,type);
        if(null == rulerList || rulerList.size() == 0){
            LOG.error("the url ruler is null,the site is {} ===",site);
            return null;
        }

        Map<String,UrlRuler> rulerMap = new HashMap<>();
        for(UrlRuler ruler : rulerList){
            rulerMap.put(ruler.getKeyword(),ruler);
        }

        // 获取父级站点规则
        String parentSite = rulerList.get(0).getParentSite();
        if(StringUtils.isNotBlank(parentSite)){
            List<UrlRuler> parentList = getRulerBySiteType(parentSite,type);
            for(UrlRuler parent : parentList){
                if(!rulerMap.containsKey(parent.getKeyword())){
                    rulerMap.put(parent.getKeyword(),parent);
                }
            }
        }

        return rulerMap;
    }

    @Override
    public Map<String, UrlRuler> getRulerByUrl(String url,Short type) {
        if (StringUtils.isBlank(url)) {
            LOG.error("the detail url is null,can't get rulers ===");
            return null;
        }
        // 获取所有规则
        List<UrlRuler> rulerList = getRulerByType(type);
        Map<String,List<UrlRuler>> rulerMap = new HashMap<>();
        String ruleKey = "";
        for(UrlRuler urlRuler : rulerList){
            if(url.indexOf(urlRuler.getSite()) > -1){
                if(urlRuler.getSite().length() > ruleKey.length()){
                    ruleKey = urlRuler.getSite();
                }
                if(rulerMap.containsKey(urlRuler.getSite())){
                    rulerMap.get(urlRuler.getSite()).add(urlRuler);
                } else{
                    List<UrlRuler> rulers = new ArrayList<>();
                    rulers.add(urlRuler);
                    rulerMap.put(urlRuler.getSite(), rulers);
                }
            }

        }

        // 获取当前 url 的规则
        List<UrlRuler> resultList = rulerMap.get(ruleKey);
        if(null == resultList || resultList.size() == 0){
            return  null;
        }
        Map<String,UrlRuler> resultMap = new HashMap<>();
        for(UrlRuler urlRuler : resultList){
            resultMap.put(urlRuler.getKeyword(),urlRuler);
        }

        //获取父类规则
        String parentSite = resultList.get(0).getParentSite();
        if(StringUtils.isNotBlank(parentSite)){
            List<UrlRuler> parentList = getRulerBySiteType(parentSite,(short) 2);
            for(UrlRuler parent : parentList){
                if(!resultMap.containsKey(parent.getKeyword())){
                    resultMap.put(parent.getKeyword(),parent);
                }
            }
        }

        rulerList = null;
        return resultMap;
    }

    @Override
    public UrlRuler getRulerByKeyWord(String site, String keyWord) {
        Map<String, UrlRuler> map = getMapRulerBySiteType(site,null);
        if(null != map && map.containsKey(keyWord)){
            return map.get(keyWord);
        }
        return null;
    }

    @Override
    public List<UrlRuler> getRulerByType(Short type) {
        Wrapper<UrlRuler> wrapper = new EntityWrapper<UrlRuler>();
        wrapper.eq("type",type);
        //wrapper.notIn(column,value);
        return this.selectList(wrapper);
    }

    @Override
    public List<UrlRuler> getRulerBySiteType(String site, Short type) {
        Wrapper<UrlRuler> wrapper = new EntityWrapper<UrlRuler>();
        if(StringUtils.isNotBlank(site)) {
            wrapper.eq("site", site);
        }
        if(null != type) {
            wrapper.eq("type", type);
        }
        return this.selectList(wrapper);
    }
}
