package com.bxm.spider.deal.dal.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.deal.common.constant.WechatConstant;
import com.bxm.spider.deal.dal.mapper.WeChatAccountMapper;
import com.bxm.spider.deal.dal.service.WeChatAccountService;
import com.bxm.spider.deal.model.RenewalModel;
import com.bxm.spider.deal.model.dao.WeChatAccount;
import com.bxm.spider.deal.model.vo.WechatAccountVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <p>
 *  微信公众号服务实现类
 * </p>
 *
 * @author JandMin
 * @since 2018-12-24
 */
@Service
public class WeChatAccountServiceImpl extends ServiceImpl<WeChatAccountMapper, WeChatAccount> implements WeChatAccountService {
    private final Logger LOG = LoggerFactory.getLogger(WeChatAccountServiceImpl.class);

    @Override
    public Boolean updateCountByMonthId(String monthId, Integer integer) {
        Wrapper<WeChatAccount> wrapper = new EntityWrapper<WeChatAccount>();
        wrapper.eq("moth_id",monthId);
        List<WeChatAccount> accounts = this.selectList(wrapper);
        if(null == accounts){
            LOG.warn("【保存公众号月发文量】公众号不存在,the monthId:{}",monthId);
            return false;
        }
        if(accounts.size() > 1){
            StringBuffer accountMsg = new StringBuffer();
            for(WeChatAccount account : accounts){
                accountMsg.append(account.getId()).append("->").append(account.getName()).append(";");
            }
            if(accountMsg.length() > 0){
                accountMsg.setLength(accountMsg.length() - 1);
            }
            LOG.error("【保存公众号月发文量】同一个monthId存在多个公众号,the monthId is {},the accountMsg:{}",monthId,accountMsg.toString());
            return false;
        }
        WeChatAccount weChatAccount = new WeChatAccount();
        weChatAccount.setId(accounts.get(0).getId());
        weChatAccount.setMothCount(integer);
        weChatAccount.setModifyTime(new Date());
        return this.updateById(weChatAccount);
    }

    @Override
    public RenewalModel isRenewal(String account) {
        RenewalModel renewalModel = new RenewalModel();
        Wrapper<WeChatAccount> wrapper = new EntityWrapper<WeChatAccount>();
        wrapper.eq("account",account);
        WeChatAccount weChatAccount = this.selectOne(wrapper);
        if(null == weChatAccount){
            renewalModel.setExist(false);
        } else {
            renewalModel.setExist(true);
            renewalModel.setStatus(weChatAccount.getStatus());
            renewalModel.setId(weChatAccount.getId());
        }
        return renewalModel;
    }

    @Override
    public List<WeChatAccount> findAccountsByTailId(int tailId) {
        Wrapper<WeChatAccount> wrapper = new EntityWrapper<>();
        wrapper.gt("moth_count",0);//大于
        wrapper.eq("status",1);
        wrapper.eq("id%10",tailId);
        wrapper.isNotNull("region_code");
        wrapper.ne("region_code","null");//不等于
        return this.selectList(wrapper);
    }

    @Override
    public List<WeChatAccount> findAccounts() {
        Wrapper<WeChatAccount> wrapper = new EntityWrapper<>();
        wrapper.gt("moth_count",0);//大于
        wrapper.eq("status",1);
        wrapper.isNotNull("region_code");
        wrapper.ne("region_code","null");//不等于
        return this.selectList(wrapper);
    }

    @Override
    public List<WeChatAccount> findAccountsByRegionCodes(List<String> regionCodes) {
        Wrapper<WeChatAccount> wrapper = new EntityWrapper<>();
        wrapper.gt("moth_count",0);//大于
        wrapper.eq("status",1);
        wrapper.in("region_code",regionCodes);
        return this.selectList(wrapper);
    }

    @Override
    public Boolean addOneAccount(WechatAccountVo wechatAccountVo) {
        if (isRenewal(wechatAccountVo.getAccount()).getExist()){
            return Boolean.FALSE;
        }
        WeChatAccount weChatAccount = new WeChatAccount();
        BeanUtils.copyProperties(wechatAccountVo,weChatAccount);

        return this.insert(weChatAccount);
    }
}
