package com.bxm.spider.deal.dal.utils;

import com.bxm.spider.cache.RedisClient;
import com.bxm.spider.cache.constant.IdKeyConstant;
import com.bxm.spider.deal.common.utils.StringHelp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * id自动生成工具类
 *
 * @ClassName IdHelps
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/30 20:15
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/30 20:15
 **/
@Component
public class IdHelps {
    @Autowired
    private RedisClient redisClient;

    public long getId(String idKeyConstant){
        Long id = redisClient.hincrByOne(IdKeyConstant.getPrimaryId(), idKeyConstant);
        if(null == id){
            id = StringHelp.getUUIDHashCode(14);
        }
        return id;
    }
}
