package com.bxm.spider.deal.dal.service;

import com.baomidou.mybatisplus.service.IService;
import com.bxm.spider.deal.model.dao.UrlRuler;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 过滤规则表 服务类
 * </p>
 *
 * @author JandMin
 * @since 2018-10-16
 */
public interface UrlRulerService extends IService<UrlRuler> {
    /**
     * 根据 url 站点获取规则
     * @date: 2018/10/18
     * @param site 站点
     * @return java.util.List<com.bxm.spider.deal.model.dao.UrlRuler>
     * @throws
     */
    List<UrlRuler> getRulerBySiteType(String site, Short type);
    /**
     * 获取所有详情url 的规则
     * @date: 2018/11/5
     * @param type 类型
     * @return java.util.List<com.bxm.spider.deal.model.dao.UrlRuler>
     * @throws
     */
    List<UrlRuler> getRulerByType(Short type);

    /**
     * 获取列表 url 规则（根据流水号）
     * @date: 2018/11/3
     * @param site
     * @param type
     * @return java.util.Map<java.lang.String,com.bxm.spider.deal.model.dao.UrlRuler>
     * @throws
     */
    Map<String,UrlRuler> getMapRulerBySiteType(String site, Short type);

    /**
     * 获取详情 规则
     * @param url
     * @param type
     * @return
     */
    Map<String,UrlRuler> getRulerByUrl(String url, Short type);

    /**
     * 根据具体的keyWord获取规则
     * @param site
     * @param keyWord
     * @return
     */
    UrlRuler getRulerByKeyWord(String site, String keyWord);
}
