package com.bxm.spider.deal.dal.service;

import com.baomidou.mybatisplus.service.IService;
import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.spider.deal.model.dao.Video;
import com.bxm.spider.deal.model.dto.VideoDto;

import java.util.List;

/**
 * <p>
 * 爬取小视频表 服务类
 * </p>
 *
 * @author JandMin
 * @since 2018-10-29
 */
public interface VideoService extends IService<Video> {
    /**
     * 根据 url 获取视频信息
     * @date: 2018/10/29
     * @param videoId
     * @return com.bxm.spider.deal.model.dao.Video
     * @throws
     */
    Video findVideoByVideoId(String videoId);

    /**
     * 保存小视频信息(除了视频url地址)
     * @date: 2018/10/29
     * @param videoDto
     * @return int
     * @throws
     */
    int saveVideo(VideoDto videoDto);

    /**
     * 修改小视频信息，除了视频url地址
     * @date: 2018/10/30
     * @param video
     * @param videoDto
     * @return int
     * @throws
     */
    int updateVideo(Video video, VideoDto videoDto);

    /**
     * 视频数据持久化操作
     * @date: 2018/11/1
     * @return void
     * @throws
     */
    Long persistVideo(VideoDto videoDto);

    /**
     * 根据条件获取视频信息
     * @date: 2018/12/20
     * @param contentDto
     * @return java.util.List<com.bxm.spider.deal.facade.model.ContentVo>
     * @throws 
     */
    List<ContentVo> findVideoList(ContentDto contentDto);
}
