package com.bxm.spider.deal.dal.service;

import com.bxm.spider.deal.model.RenewalModel;
import com.bxm.spider.deal.model.dao.WeChatAccount;
import com.baomidou.mybatisplus.service.IService;

import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author JandMin
 * @since 2018-12-24
 */
public interface WeChatAccountService extends IService<WeChatAccount> {

    /**
     * 根据 月发文id 修改月发文数量
     * @date: 2018/12/25
     * @param monthId
     * @param integer
     * @return java.lang.Boolean
     * @throws 
     */
    Boolean updateCountByMonthId(String monthId, Integer integer);

    /**
     * 查看是否存在和是否需要更新
     * @date: 2018/12/25
     * @param account
     * @return com.bxm.spider.deal.model.RenewalModel
     * @throws 
     */
    RenewalModel isRenewal(String account);

    /**
     * 根据 id 尾号获取月发文大于0的公众号信息
     * @date: 2019/1/7
     * @param tailId
     * @return java.util.List<com.bxm.spider.deal.model.dao.WeChatAccount>
     * @throws 
     */
    List<WeChatAccount> findAccountsByTailId(int tailId);

    /**
     * 获取月发文大于0的公众号信息
     * @date: 2019/1/11
     * @return java.util.List<com.bxm.spider.deal.model.dao.WeChatAccount>
     */
    List<WeChatAccount> findAccounts();

    /**
     * 根据regionCode列表获取月发文大于0的的所有账号
     * @param regionCodes
     * @return
     */
    List<WeChatAccount> findAccountsByRegionCodes(List<String> regionCodes);

}
