package com.bxm.spider.deal.dal.service;

import com.baomidou.mybatisplus.service.IService;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.spider.deal.model.dao.WechatNews;
import com.bxm.spider.deal.model.dao.WechatNewsContent;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 爬取微信新闻表(分表) 服务类
 * </p>
 *
 * @author JandMin
 * @since 2018-10-16
 */
public interface WechatNewsDbService extends IService<WechatNews> {

    int insertNews(WechatNews news);

    int updateNewsById(WechatNews news);

    void insertNewsAndContent(WechatNews news, WechatNewsContent newsContent, ProcessorParameter processorParameter);

    WechatNews findNewsByTitle(String title);

    Map<String,String> findNewsById(Long id, String suffix);

    List<ContentVo> listContent(ContentDto contentDto);

}
