package com.bxm.spider.deal.dal.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.deal.dal.mapper.CompanyMapper;
import com.bxm.spider.deal.dal.service.CompanyService;
import com.bxm.spider.deal.model.dao.Company;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 招聘公司表 服务实现类
 * </p>
 *
 * @author JandMin
 * @since 2018-11-20
 */
@Service
public class CompanyServiceImpl extends ServiceImpl<CompanyMapper, Company> implements CompanyService {

    @Override
    public List<Company> selectByUrl(List<String> companyUrls) {
        Wrapper<Company> wrapper = new EntityWrapper<Company>();
        wrapper.in("url",companyUrls);
        return this.selectList(wrapper);
    }

    @Override
    public Company selectOneByUrl(String url) {
        Wrapper<Company> wrapper = new EntityWrapper<Company>();
        wrapper.eq("url_code",url.hashCode());
        return this.selectOne(wrapper);
    }
}
