package com.bxm.spider.deal.facade.model;

import com.bxm.spider.constant.processor.ProcessorParameter;

/**
 * 处理中心数据传输对象
 *
 * @ClassName DealDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/11/30 17:35
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/11/30 17:35
 **/
public class DealDto {
    /**
     * 下载的页面信息
     */
    private String pageInfo;

    /**
     * 数据流
     */
    private String imageStr;
    /**
     * 公共传输对象
     */
    private ProcessorParameter processorParameter;

    public String getPageInfo() {
        return pageInfo;
    }

    public void setPageInfo(String pageInfo) {
        this.pageInfo = pageInfo;
    }

    public String getImageStr() {
        return imageStr;
    }

    public void setImageStr(String imageStr) {
        this.imageStr = imageStr;
    }

    public ProcessorParameter getProcessorParameter() {
        return processorParameter;
    }

    public void setProcessorParameter(ProcessorParameter processorParameter) {
        this.processorParameter = processorParameter;
    }

    @Override
    public String toString() {
        if(null == processorParameter){
            return super.toString();
        }
        return "url='" + processorParameter.getUrl() + '\'' +
                ", originUrl='" + processorParameter.getOriginUrl() + '\'' +
                ", serialNum='" + processorParameter.getSerialNum() + '\'' +
                ", type=" + processorParameter.getType() +
                ", processorEnum=" + processorParameter.getProcessorEnum() +
                ", persistenceEnum=" + processorParameter.getPersistenceEnum() +
                ", jsonObject='" + processorParameter.getJsonObject() + '\'' +
                '}';
    }
}
