package com.bxm.spider.deal.facade.service;

import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.warcar.utils.response.ResponseModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p> 内容处理相关服务 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/12/20
 */
@FeignClient(name ="deal-service")
public interface ContentDealFacadeService {
    /**
     * 修改新闻状态
     * @date: 2018/12/19
     * @param persistenceEnum
     * @param status
     * @param ids
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Integer>
     * @throws
     */
    @RequestMapping(value = "/content/update/status", method = RequestMethod.POST)
    ResponseModel<Integer> updateStatus(@RequestParam("persistenceEnum") String persistenceEnum,@RequestParam("status") Integer status,@RequestParam("ids") Long[] ids);

    /**
     * 分页查询内容
     * @date: 2018/12/20
     * @param contentDto
     * @return com.bxm.warcar.utils.response.ResponseModel<com.github.pagehelper.PageInfo<com.bxm.spider.deal.facade.model.ContentVo>>
     * @throws 
     */
    @RequestMapping(value = "/content/list", method = RequestMethod.POST)
    ResponseModel<PageInfo<ContentVo>> listContent(@RequestBody ContentDto contentDto);
}
