package com.bxm.spider.deal.facade.service;

import com.bxm.spider.deal.facade.model.DealDto;
import com.bxm.warcar.utils.response.ResponseModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * <p> 页面内容处理器</p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/10/16
 */
@FeignClient(name ="deal-service")
public interface ProcessorFacadeService {
    /**
     * 页面内容解析(下载中心下载页面后调用)
     * @date: 2018/11/20
     * @param dealDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws 
     */
    @RequestMapping(value = "/deal/processor", method = RequestMethod.POST)
    ResponseModel<Boolean> processor(@RequestBody DealDto dealDto);

    /**
     * 图片处理
     * @date: 2018/11/20
     * @param dealDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws 
     */
    @RequestMapping(value = "/deal/image", method = RequestMethod.POST)
    ResponseModel<Boolean> imageProcessor(@RequestBody DealDto dealDto);
}
