package com.bxm.spider.deal.integration.task;

import com.alibaba.fastjson.JSONObject;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.constant.url.UrlTypeEnum;
import com.bxm.spider.prod.facade.model.dto.TaskUrlDto;
import com.bxm.spider.prod.facade.service.TaskFeignService;
import com.bxm.spider.response.ResponseModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p> 任务相关服务调用 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/10/22
 */
@Service
public class TaskIntegration {
    private static final Logger LOG = LoggerFactory.getLogger(TaskIntegration.class);

    @Autowired
    private TaskFeignService taskFeignService;

    /**
     * 解析出来的详情url  push到调度中心
     * @date: 2018/10/22
     * @param urlList url 列表
     * @param processorParameter
     * @param forcedDownload 是否强制下载
     * @return java.lang.Boolean
     * @throws 
     */
    public Boolean pushDetailsList(List<String> urlList, ProcessorParameter processorParameter, Boolean forcedDownload){
        //参数校验
        if(StringUtils.isBlank(processorParameter.getSerialNum())){
            LOG.warn("【发送详情url】the serialNum is null.");
            return false;
        }
        if(null == urlList || urlList.size() == 0){
            LOG.warn("【发送详情url】the url list is null,the serial num is {}",processorParameter.getSerialNum());
            return false;
        }
        if(LOG.isDebugEnabled()){
            LOG.debug("【发送详情url】originUrl is {},detail url size is {}，first url is {}",processorParameter.getOriginUrl(),
                    urlList.size(),urlList.get(0));
        }
        //参数封装
        TaskUrlDto taskUrlDto = new TaskUrlDto();
        taskUrlDto.setSerialNum(processorParameter.getSerialNum());
        taskUrlDto.setUrlList(JSONObject.toJSONString(urlList));
        taskUrlDto.setOriginUrl(processorParameter.getOriginUrl());
        taskUrlDto.setForcedDownload(forcedDownload);
        taskUrlDto.setJsonObject(processorParameter.getJsonObject());
        taskUrlDto.setPersistenceEnum(processorParameter.getPersistenceEnum());
        taskUrlDto.setProcessorEnum(processorParameter.getProcessorEnum());
        taskUrlDto.setType(processorParameter.getType().equals(UrlTypeEnum.URL_COMMENT)?UrlTypeEnum.URL_COMMENT:null);

        try {
            // cloud 调用
            ResponseModel<Boolean> result = taskFeignService.pushDetailsList(taskUrlDto);
            if(result.isSuccess()){
                return true;
            }else{
                LOG.error("【发送详情url】error,msg:{}",result.getMessage());
                return false;
            }
        } catch (Exception e) {
            LOG.error("【发送详情url】error ,the serial number is {}",processorParameter.getSerialNum(),e);
            return false;
        }
    }

    /**
     * 解析出来的列表url  push到调度中心
     * @date: 2018/10/22
     * @param urlList
     * @param processorParameter
     * @return java.lang.Boolean
     * @throws 
     */
    public Boolean pushQueueList(List<String> urlList,ProcessorParameter processorParameter, Boolean forcedDownload, Boolean prodFirst){
        //参数校验
        if(StringUtils.isBlank(processorParameter.getSerialNum())){
            LOG.warn("【发送列表url】 error,the serialNum is null.");
            return false;
        }
        if(null == urlList || urlList.size() == 0){
            LOG.warn("【发送列表url】 error,the url list is null,the serial num is {}",processorParameter.getSerialNum());
            return false;
        }
        //参数封装
        TaskUrlDto taskUrlDto = new TaskUrlDto();
        taskUrlDto.setSerialNum(processorParameter.getSerialNum());
        taskUrlDto.setUrlList(JSONObject.toJSONString(urlList));
        taskUrlDto.setOriginUrl(processorParameter.getOriginUrl());
        taskUrlDto.setForcedDownload(forcedDownload);
        taskUrlDto.setJsonObject(processorParameter.getJsonObject());
        taskUrlDto.setPersistenceEnum(processorParameter.getPersistenceEnum());
        taskUrlDto.setProcessorEnum(processorParameter.getProcessorEnum());
        taskUrlDto.setProdFirst(prodFirst);

        try {
            // cloud 调用
            ResponseModel<Boolean> result = taskFeignService.pushQueueList(taskUrlDto);
            if(result.isSuccess()){
                return true;
            }else{
                LOG.error("【发送列表url】error,msg:{}",result.getMessage());
                return false;
            }
        } catch (Exception e) {
            LOG.error("【发送列表url】 error ,the serial number is {}",processorParameter.getSerialNum(),e);
            return false;
        }
    }

    /**
     * 图片下载
     * @date: 2018/11/21
     * @param urlList
     * @param processorParameter
     * @return java.lang.Boolean
     * @throws 
     */
    public Boolean pushImageUrl(List<String> urlList,ProcessorParameter processorParameter){
        //参数校验
        if(StringUtils.isBlank(processorParameter.getSerialNum())){
            LOG.warn("【发送图片url】 error,the serialNum is null.");
            return false;
        }
        if(null == urlList || urlList.size() == 0){
            LOG.warn("【发送图片url】 error,the url list is null,the serial num is {}",processorParameter.getSerialNum());
            return false;
        }
        try {
            //参数封装
            TaskUrlDto taskUrlDto = new TaskUrlDto();
            taskUrlDto.setSerialNum(processorParameter.getSerialNum());
            taskUrlDto.setUrlList(JSONObject.toJSONString(urlList));
            taskUrlDto.setOriginUrl(processorParameter.getOriginUrl());
            taskUrlDto.setJsonObject(processorParameter.getJsonObject());
            taskUrlDto.setPersistenceEnum(processorParameter.getPersistenceEnum());
            taskUrlDto.setProcessorEnum(processorParameter.getProcessorEnum());
            taskUrlDto.setForcedDownload(true);
            // cloud 调用
            ResponseModel<Boolean> result = taskFeignService.pushImageList(taskUrlDto);
            LOG.info("【发送图片url结束】serialNum:{},originUrl:{},url:{}",processorParameter.getSerialNum(),processorParameter.getOriginUrl(),JSONObject.toJSONString(urlList));
            if(result.isSuccess()){
                return true;
            }else{
                LOG.error("【发送图片url结束】error,msg:{}",result.getMessage());
                return false;
            }
        } catch (Exception e) {
            LOG.error("【发送图片url】 error ,the serial number is {}",processorParameter.getSerialNum(),e);
            return false;
        }
    }
}
