/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.deal.timer.job.jobs;

import com.alibaba.fastjson.JSONObject;
import com.bxm.spider.deal.common.utils.StringHelp;
import com.bxm.spider.deal.dal.service.CompanyService;
import com.bxm.spider.deal.dal.service.WorkService;
import com.bxm.spider.deal.model.dao.Company;
import com.bxm.spider.deal.model.dao.Work;
import com.bxm.spider.deal.model.vo.RecruitMessageVo;
import com.bxm.spider.deal.model.vo.WorkVo;
import com.bxm.spider.deal.timer.job.Job;
import com.bxm.spider.deal.timer.job.config.RecruitJobConfiguration;
import com.bxm.spider.deal.timer.job.constant.RecruitConstant;
import com.bxm.spider.deal.timer.job.utils.HttpUtil;
import com.bxm.spider.utils.DateUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableConfigurationProperties(value={RecruitJobConfiguration.class})
public class RecruitMessageJob
implements Job {
    private Logger logger = LoggerFactory.getLogger(RecruitMessageJob.class);
    @Autowired
    private WorkService workService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private RecruitJobConfiguration recruitConfig;
    private static final String POST_PARA_NAME = "crawlerInfo";
    private Map<Long, String> map = null;
    private int count = 0;

    @Scheduled(cron="${scheduling.recruit.time}")
    public void execute() {
        Long start = System.currentTimeMillis();
        List workList = this.workService.selectByModifyTime(this.recruitConfig.getTimeBefore());
        if (null == workList || workList.size() == 0) {
            this.logger.info("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u65e0\u6570\u636e\u66f4\u65b0\uff0c\u4e0d\u540c\u6b65");
            return;
        }
        this.map = new HashMap();
        this.count = 0;
        ArrayList<String> companyUrls = new ArrayList<String>();
        HashMap workVoMap = new HashMap();
        for (Work work : workList) {
            if (null == work) continue;
            String msg = this.checkMsg(work);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u4fe1\u606f\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u4fe1\u606f\u4e3a\uff1a{}\uff0cwork:{}", (Object)msg, (Object)work);
                ++this.count;
                continue;
            }
            WorkVo workVo = this.copyWorkMsg(work);
            if (null == workVo) {
                this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u5de5\u4f5c\u4fe1\u606fcopy\u5931\u8d25\uff0cwork\u53c2\u6570\uff1a{}", (Object)work);
                continue;
            }
            companyUrls.add(work.getCompanyUrl());
            if (workVoMap.containsKey(work.getCompanyUrl())) {
                ((List)workVoMap.get(work.getCompanyUrl())).add(workVo);
                continue;
            }
            ArrayList<WorkVo> workVoList = new ArrayList<WorkVo>();
            workVoList.add(workVo);
            workVoMap.put(work.getCompanyUrl(), workVoList);
        }
        if (null == companyUrls || companyUrls.size() == 0) {
            this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object)(System.currentTimeMillis() - start));
            this.count = 0;
            this.map = null;
            return;
        }
        List companyList = this.companyService.selectByUrl(companyUrls);
        ArrayList<RecruitMessageVo> messageVoList = new ArrayList<RecruitMessageVo>();
        for (Company company : companyList) {
            if (null == company || StringUtils.isBlank((CharSequence)company.getAddress())) {
                this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u516c\u53f8\u4e3anull \u6216\u5730\u5740\u4e3a\u7a7a\uff1a{}", (Object)company);
            }
            if (!workVoMap.containsKey(company.getUrl()) || null == workVoMap.get(company.getUrl())) continue;
            RecruitMessageVo messageVo = this.copyCompanyMsg(company, (List)workVoMap.get(company.getUrl()));
            if (null == messageVo) {
                this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u516c\u53f8\u4fe1\u606f\u5168\uff1a{}", (Object)company);
                continue;
            }
            messageVoList.add(messageVo);
            this.logger.info("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u516c\u53f8\uff1a{} \u5bf9\u5e94\u7684\u5c97\u4f4d\u6570\u4e3a\uff1a{}", (Object)company.getCompanyName(), (Object)((List)workVoMap.get(company.getUrl())).size());
        }
        if (null != messageVoList && messageVoList.size() > 0) {
            String result;
            HashMap<String, String> para = new HashMap<String, String>();
            para.put(POST_PARA_NAME, JSONObject.toJSONString(messageVoList));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u53c2\u6570\u4e3a\uff1a{},url:{}", (Object)JSONObject.toJSONString(para), (Object)this.recruitConfig.getUrl());
            }
            if (StringUtils.isNotBlank((CharSequence)(result = HttpUtil.okHttpPost((String)this.recruitConfig.getUrl(), para)))) {
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                if (null != jsonObject && null != jsonObject.get((Object)"returnValue") && ((Boolean)jsonObject.get((Object)"returnValue")).booleanValue()) {
                    this.logger.info("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u540c\u6b65\u516c\u53f8\u548c\u5c97\u4f4d\u4fe1\u606f\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a{},\u540c\u6b65\u516c\u53f8\u6570\u4e3a\uff1a{}\uff0cdimCount:{},map:{},\u8017\u65f6\uff1a{} \u6beb\u79d2", new Object[]{result, messageVoList.size(), this.count, this.map, System.currentTimeMillis() - start});
                } else {
                    this.logger.error("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u540c\u6b65\u516c\u53f8\u548c\u5c97\u4f4d\u4fe1\u606f\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c:{},\u540c\u6b65\u516c\u53f8\u6570\u4e3a\uff1a{}\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2", new Object[]{result, messageVoList.size(), System.currentTimeMillis() - start});
                }
            } else {
                this.logger.error("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u540c\u6b65\u516c\u53f8\u548c\u5c97\u4f4d\u4fe1\u606f\u7ed3\u675f\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3anull,\u540c\u6b65\u516c\u53f8\u6570\u4e3a\uff1a{}\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object)messageVoList.size(), (Object)(System.currentTimeMillis() - start));
            }
        } else {
            this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u516c\u53f8\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a\uff0c\u65e0\u9700\u540c\u6b65\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object)(System.currentTimeMillis() - start));
        }
        this.count = 0;
        this.map = null;
    }

    private RecruitMessageVo copyCompanyMsg(Company company, List<WorkVo> workList) {
        if (null == workList) {
            this.logger.error("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u516c\u53f8\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f\u4e3anull");
            return null;
        }
        boolean flag = false;
        if (StringUtils.isBlank((CharSequence)company.getAddress())) {
            flag = true;
        }
        RecruitMessageVo messageVo = new RecruitMessageVo();
        for (int i = 0; i < workList.size(); ++i) {
            WorkVo workVo = workList.get(i);
            if (null == workVo) continue;
            if (flag && StringUtils.isNotBlank((CharSequence)workVo.getAddress())) {
                company.setAddress(workVo.getAddress());
                flag = false;
            }
            if (StringUtils.isNotBlank((CharSequence)workVo.getMobile())) continue;
            if (StringUtils.isBlank((CharSequence)company.getMobile()) && StringUtils.isBlank((CharSequence)company.getPhone())) {
                workList.remove(i);
                this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u624b\u673a\u53f7\u548c\u7535\u8bdd\u4e3a\u7a7a\uff1a{}", (Object)workVo);
                this.map.put(workVo.getCrawlerId(), company.getCompanyName());
                continue;
            }
            String mobile = this.getRightMobile(new String[]{company.getMobile(), company.getPhone()});
            if (StringUtils.isBlank((CharSequence)mobile)) {
                workList.remove(i);
                this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u624b\u673a\u53f7\u548c\u7535\u8bdd\u4e3a\u683c\u5f0f\u6709\u8bef\uff1a{}", (Object)workVo);
                this.map.put(workVo.getCrawlerId(), company.getCompanyName());
                continue;
            }
            workVo.setMobile(mobile);
        }
        if (flag) {
            this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u516c\u53f8\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        messageVo.setCrawlerId(company.getId());
        messageVo.setFullName(company.getCompanyName());
        messageVo.setShortName(company.getCompanyName());
        messageVo.setIndustry(company.getIndustry());
        messageVo.setScale(StringHelp.isContainChinese((String)company.getCompanyScale()) ? company.getCompanyScale() : company.getCompanyScale() + "\u4eba");
        messageVo.setNature(company.getCompanyType());
        if (StringUtils.isNotBlank((CharSequence)company.getLatitude()) && StringUtils.isNotBlank((CharSequence)company.getLongitude())) {
            try {
                messageVo.setAddressLat(new BigDecimal(company.getLatitude()));
                messageVo.setAddressLon(new BigDecimal(company.getLongitude()));
            }
            catch (Exception e) {
                this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u516c\u53f8\u7ecf\u7eac\u5ea6\u4fe1\u606f\u8f6c\u6362\u5931\u8d25\uff0c\u7ecf\u5ea6\uff1a{},\u7eac\u5ea6\uff1a{}", new Object[]{company.getLongitude(), company.getLatitude(), e});
            }
        }
        messageVo.setAddress(company.getAddress());
        this.setArea(messageVo, company.getRegion());
        messageVo.setIntroduction(company.getDesc());
        messageVo.setLogo(company.getLogoUrl());
        messageVo.setState(company.getStatus());
        messageVo.setJobListInfo(workList);
        return messageVo;
    }

    private void setArea(RecruitMessageVo messageVo, String region) {
        if (StringUtils.isNotBlank((CharSequence)region)) {
            for (String key : RecruitConstant.REGION_MAP.keySet()) {
                if (region.indexOf(key) == -1) continue;
                region = (String)RecruitConstant.REGION_MAP.get(key);
                break;
            }
            messageVo.setArea(region);
        }
    }

    private WorkVo copyWorkMsg(Work work) {
        WorkVo workVo = new WorkVo();
        workVo.setCrawlerId(work.getId());
        workVo.setWorkType(work.getWorkType());
        this.setSalary(workVo, work.getSalary());
        workVo.setGenderReq(this.getGenderFlag(work.getSex()));
        this.setAge(workVo, work.getAge());
        workVo.setEduReq(work.getEducation());
        workVo.setWorkContent(work.getDesc());
        this.setPeopleNum(workVo, work.getPeopleNum());
        workVo.setStartTime(work.getModifyTime());
        this.setEndTime(workVo, work.getModifyTime());
        workVo.setMobile(this.getRightMobile(new String[]{work.getMobile(), work.getPhone()}));
        workVo.setState(work.getStatus());
        workVo.setAddress(work.getAddress());
        workVo.setHireMode(Integer.valueOf(1));
        return workVo;
    }

    private String getRightMobile(String ... phones) {
        for (String phone : phones) {
            if (StringUtils.isBlank((CharSequence)phone) || phone.length() > 13 || phone.length() < 5 || StringHelp.isContainChinese((String)phone) || StringHelp.isContainLetter((String)phone)) continue;
            return phone;
        }
        return "";
    }

    private void setEndTime(WorkVo workVo, Date modifyTime) {
        try {
            if (null == modifyTime) {
                modifyTime = new Date();
            }
            String end = DateUtils.getDate((String)DateUtils.convertDateToString((Date)modifyTime, (String)"yyyy-MM-dd HH:mm:ss"), (int)14, (String)"yyyy-MM-dd HH:mm:ss");
            workVo.setEndTime(DateUtils.convertStringToDate((String)end, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        catch (ParseException e) {
            this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u5c97\u4f4d\u4fe1\u606f\u3011\u7ed3\u675f\u65f6\u95f4\u8bbe\u7f6e\u5931\u8d25\uff0cmodifyTime\uff1a{}", (Object)modifyTime, (Object)e);
        }
    }

    private void setPeopleNum(WorkVo workVo, String peopleNum) {
        try {
            workVo.setHireNum(Integer.valueOf(StringUtils.isNotBlank((CharSequence)peopleNum) && StringUtils.isNumeric((CharSequence)peopleNum.replaceAll("\u4eba.*?$", "").trim()) ? Integer.valueOf(peopleNum.replaceAll("\u4eba.*?$", "").trim()) : 1));
        }
        catch (Exception e) {
            this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u62db\u8058\u4eba\u6570\u4fe1\u606f\u8f6c\u6362\u5931\u8d25\uff0cerror:", (Throwable)e);
            workVo.setHireNum(Integer.valueOf(1));
        }
    }

    private void setAge(WorkVo workVo, String age) {
        String[] ageArray = age.split("\u2014\u2014");
        if (ageArray.length == 1) {
            ageArray = age.split("-");
        }
        if (ageArray.length == 2) {
            try {
                workVo.setAgeMinReq(Integer.valueOf(ageArray[0].trim()));
                workVo.setAgeMaxReq(Integer.valueOf(ageArray[1].trim()));
                return;
            }
            catch (Exception e) {
                this.logger.error("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u5e74\u9f84\u8981\u6c42\u4fe1\u606f\u8f6c\u6362\u5931\u8d25\uff0cerror:", (Throwable)e);
            }
        }
        workVo.setAgeMinReq(RecruitConstant.AGE_MIN);
        workVo.setAgeMaxReq(RecruitConstant.AGE_MAX);
    }

    private void setSalary(WorkVo workVo, String salary) {
        if (StringUtils.isNotBlank((CharSequence)salary)) {
            if (salary.indexOf("\u4ee5\u4e0a") != -1) {
                for (String key : RecruitConstant.SALARY_MAP.keySet()) {
                    if (salary.indexOf(key) == -1) continue;
                    salary = salary.replaceAll(key, (String)RecruitConstant.SALARY_MAP.get(key));
                }
            }
            for (String place : RecruitConstant.SALARY_PLACE_BEFORE) {
                salary = salary.replaceAll(place, "");
            }
            for (String spl : RecruitConstant.SALARY_SPLIT) {
                String[] salArray = salary.split(spl);
                if (salArray.length != 2) continue;
                try {
                    workVo.setSalaryMin(Integer.valueOf(salArray[0].trim()));
                    workVo.setSalaryMax(Integer.valueOf(salArray[1].trim()));
                    return;
                }
                catch (Exception e) {
                    this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u5de5\u8d44\u6700\u5927\u503c\u6700\u5c0f\u503c\u4fe1\u606f\u8f6c\u6362\u5931\u8d25\uff0csalary:{}", (Object)salary, (Object)e);
                }
            }
            try {
                salary = salary.replaceAll("\\+", "").trim();
                if (!StringUtils.isNumeric((CharSequence)salary)) {
                    this.logger.warn("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u5de5\u8d44\u683c\u5f0f\u6709\u8bef\uff0csalary:{}\uff0cworkVo:{}", (Object)salary, (Object)workVo);
                    return;
                }
                workVo.setSalaryMin(Integer.valueOf(salary));
                workVo.setSalaryMax(Integer.valueOf(Integer.valueOf(salary) + 5000));
            }
            catch (Exception e) {
                this.logger.error("\u3010\u540c\u6b65\u62db\u8058\u4fe1\u606f\u3011\u5de5\u8d44\u8981\u6c42\u4fe1\u606f\u8f6c\u6362\u5931\u8d25\uff0csalary:{},error:", (Object)salary, (Object)e);
            }
        }
    }

    private short getGenderFlag(String sex) {
        if (sex.indexOf("\u7537") != -1 && sex.indexOf("\u5973") == -1) {
            return 1;
        }
        if (sex.indexOf("\u7537") == -1 && sex.indexOf("\u5973") != -1) {
            return 2;
        }
        return 0;
    }

    private String checkMsg(Work work) {
        StringBuffer sb = new StringBuffer();
        if (null == work.getSalary() || !StringHelp.isContainNumber((String)work.getSalary())) {
            sb.append("\u5de5\u8d44\u683c\u5f0f\u6709\u8bef").append(",");
        }
        if (StringUtils.isBlank((CharSequence)work.getCompanyUrl())) {
            sb.append("\u516c\u53f8url\u4e3a\u7a7a").append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

