/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.deal.timer.job.jobs;

import com.bxm.spider.deal.integration.DealIntegration;
import com.bxm.spider.deal.timer.job.Job;
import com.bxm.spider.deal.timer.job.jobs.RecruitMessageJob;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class RepeatCacheSimHashJob
implements Job {
    private Logger logger = LoggerFactory.getLogger(RecruitMessageJob.class);
    @Autowired
    private DealIntegration dealIntegration;

    @Scheduled(cron="10 6 0 * * ?")
    public void execute() {
        try {
            Map simHashCount = this.dealIntegration.countSimHashCache();
            this.logger.info("\u3010\u521d\u59cb\u5316\u53bb\u91cdsimHash\u7f13\u5b58\u3011start -> content size:{},title size:{}", simHashCount.get("CONTENT"), simHashCount.get("TITLE"));
        }
        catch (Exception e) {
            this.logger.info("\u3010\u521d\u59cb\u5316\u53bb\u91cdsimHash\u7f13\u5b58\u3011 \u83b7\u53d6size \u5931\u8d25\uff1a", (Throwable)e);
        }
        long start = System.currentTimeMillis();
        Map result = this.dealIntegration.initializeSimHash();
        this.logger.info("\u3010\u521d\u59cb\u5316\u53bb\u91cdsimHash\u7f13\u5b58\u3011end -> content size:{},title size:{},spend {} ms", new Object[]{result.get("CONTENT"), result.get("TITLE"), System.currentTimeMillis() - start});
    }
}

