package com.bxm.spider.deal.timer;

import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;

@MapperScan(basePackages = "com.bxm.spider.deal.dal.mapper")
@ComponentScan(basePackages = "com.bxm.spider")
@EnableFeignClients({"com.bxm.spider.deal.facade","com.bxm.spider.prod.facade"})
@EnableEurekaClient
@SpringBootApplication
@EnableScheduling
@EnableApolloConfig
public class DealTimerApplication{

	public static void main(String[] args) {
		SpringApplication.run(DealTimerApplication.class, args);
	}

}
