package com.bxm.spider.deal.timer.job.jobs;

import com.bxm.spider.cache.constant.SimHashConstant;
import com.bxm.spider.deal.integration.DealIntegration;
import com.bxm.spider.deal.timer.job.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

import java.util.Map;

/**
 * <p> simHas去重数据初始化加载 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/1/10
 */
@Configuration
public class RepeatCacheSimHashJob implements Job {
    private Logger logger = LoggerFactory.getLogger(RecruitMessageJob.class);

    @Autowired
    private DealIntegration dealIntegration;

    @Scheduled(cron = "10 6 0 * * ?")
    @Override
    public void execute() {

        try {
            Map<String, Integer> simHashCount = dealIntegration.countSimHashCache();
            logger.info("【初始化去重simHash缓存】start -> content size:{},title size:{}", simHashCount.get(SimHashConstant.SIMHASH_CONTENT), simHashCount.get(SimHashConstant.SIMHASH_TITLE));
        } catch (Exception e){
            logger.info("【初始化去重simHash缓存】 获取size 失败：",e);
        }

        long start = System.currentTimeMillis();

        Map<String,Integer> result = dealIntegration.initializeSimHash();

        logger.info("【初始化去重simHash缓存】end -> content size:{},title size:{},spend {} ms",result.get(SimHashConstant.SIMHASH_CONTENT),result.get(SimHashConstant.SIMHASH_TITLE),(System.currentTimeMillis() - start));

    }
}
