package com.bxm.spider.deal.facade.model;

import com.bxm.spider.multipage.MultiPageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * <p> 内容相关参数 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/12/20
 */
@ApiModel(value="内容查询参数",description="内容参数对象")
public class ContentDto extends MultiPageParam implements Serializable{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("存储器:NEWS,WECHAT,VIDEO,WECHATNEWS")
    private String     persistenceEnum;
    @ApiModelProperty("标题")
    private String     title;
    @ApiModelProperty("url链接")
    private String     url;
    @ApiModelProperty("最早爬取时间")
    private String     start;
    @ApiModelProperty("最晚爬取时间")
    private String     end;
    @ApiModelProperty("当前页")
    private Integer    currentPage = 1;
    @ApiModelProperty("每页大小")
    private Integer    pageSize = 20;
    @ApiModelProperty("id 集合")
    private List<Long> idList;

    public String getPersistenceEnum() {
        return persistenceEnum;
    }

    public void setPersistenceEnum(String persistenceEnum) {
        this.persistenceEnum = persistenceEnum;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getStart() {
        return start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public List<Long> getIdList() {
        return idList;
    }

    public void setIdList(List<Long> idList) {
        this.idList = idList;
    }
}
