package com.bxm.spider.deal.facade.service;

import com.bxm.spider.response.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.Map;

/**
 * <p> 去重数据服务 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/1/10
 */
@FeignClient(name ="deal-service")
public interface RepeatCacheFacadeService {

    /**
     * 初始化最近几天的内容simHash到redis,用于去重
     * @date: 2019/1/10
     * @param 
     * @return com.bxm.spider.response.ResponseModel<java.util.Map<java.lang.String,java.lang.Integer>>
     * @throws 
     */
    @RequestMapping(value = "/simhash/init", method = RequestMethod.PUT)
    ResponseModel<Map<String,Integer>> initializeSimHash();

    /**
     * 统计simHash 近15天的数量
     * @date: 2019/1/10
     * @param 
     * @return com.bxm.spider.response.ResponseModel<java.util.Map<java.lang.String,java.lang.Integer>>
     * @throws 
     */
    @RequestMapping(value = "/simhash/dimCount", method = RequestMethod.PUT)
    ResponseModel<Map<String,Integer>> countSimHashCache();

}
