package com.bxm.spider.manager.integration.prod.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.spider.deal.facade.model.PageDealVo;
import com.bxm.spider.response.ResponseModel;

/**
 * <p> 内容处理调用 deal facade </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/12/20
 */
public interface ContentDealIntegrationService {

    /**
     * 修改状态
     * @date: 2018/12/20
     * @param persistenceEnum
     * @param status
     * @param ids
     * @return com.bxm.spider.response.ResponseModel<java.lang.Integer>
     * @throws 
     */
    ResponseModel<Integer> updateStatus(String persistenceEnum, Integer status, Long[] ids);

    /**
     * 分页哈寻内容
     * @date: 2018/12/20
     * @param contentDto
     * @return com.bxm.spider.response.ResponseModel<com.github.pagehelper.PageInfo<com.bxm.spider.deal.facade.model.ContentVo>>
     * @throws 
     */
    ResponseModel<Page<ContentVo>> listContent(ContentDto contentDto);

    /**
     * 单页内容处理
     * @param content
     * @param selector
     * @return
     */
    PageDealVo dealPage(String content, String selector);

    /**
     * 获取选择器抓取的第一个页面内容
     * @param content 页面
     * @param selector 选择器
     * @return 抓取到的内容
     */
    String select(String content, String selector, String attr);
}
