package com.bxm.spider.manager.integration.prod.service;


import com.bxm.spider.prod.facade.model.dto.TaskDto;
import com.bxm.spider.response.ResponseModel;

/**
 * 任务调度服务
 *
 * @ClassName TaskFeignIntegrationService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/18 13:54
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/18 13:54
 **/
public interface TaskFeignIntegrationService {
    /**
     * 启动任务
     *
     * @param taskDto
     * @return com.bxm.spider.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/18 11:06
     */
    ResponseModel<Boolean> start(TaskDto taskDto);

    /**
     * 暂停任务
     *
     * @param taskDto
     * @return com.bxm.spider.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/18 11:06
     */
    ResponseModel<Boolean> pause(TaskDto taskDto);

    /**
     * 更新任务
     *
     * @param taskDto
     * @return com.bxm.spider.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/18 11:06
     */
    ResponseModel<Boolean> resume(TaskDto taskDto);

    /**
     * 停止任务
     *
     * @param taskDto
     * @return com.bxm.spider.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/18 11:06
     */
    ResponseModel<Boolean> stop(TaskDto taskDto);

    /**
     * 重启所有的任务
     *
     * @return com.bxm.spider.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/12/10 17:10
     */
    ResponseModel<Boolean> restartAll();

}
