package com.bxm.spider.manager.integration.prod.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.spider.constant.task.TaskConstant;
import com.bxm.spider.deal.facade.model.*;
import com.bxm.spider.deal.facade.service.ContentDealFacadeService;
import com.bxm.spider.deal.facade.service.ProcessorFacadeService;
import com.bxm.spider.manager.integration.prod.service.ContentDealIntegrationService;
import com.bxm.spider.response.ResponseModel;
import com.bxm.spider.response.ResponseModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p></p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/12/20
 */
@Service
public class ContentDealIntegrationServiceImpl implements ContentDealIntegrationService {

    @Autowired
    private ContentDealFacadeService contentDealFacadeService;

    @Autowired
    private ProcessorFacadeService processorFacadeService;

    @Override
    public ResponseModel<Integer> updateStatus(String persistenceEnum, Integer status, Long[] ids) {
        return contentDealFacadeService.updateStatus(persistenceEnum,status,ids);
    }

    @Override
    public ResponseModel<Page<ContentVo>> listContent(ContentDto contentDto) {
        return contentDealFacadeService.listContent(contentDto);
    }

    @Override
    public PageDealVo dealPage(String content, String selector) {
        PageDealDto pageDealDto = new PageDealDto();
        pageDealDto.setContent(content);
        pageDealDto.setSelector(selector);

        ResponseModel<PageDealVo> responseModel = ResponseModelFactory.FAILED();
        try{
            responseModel = processorFacadeService.pageProcessor(pageDealDto);
        }catch (Exception e){
            // 重试
            for (int i = 0; i < TaskConstant.RETRY_TIME; i++) {
                responseModel = processorFacadeService.pageProcessor(pageDealDto);
                if (responseModel.isSuccess()) {
                    break;
                }
            }
        }

        return responseModel.getData();
    }

    @Override
    public String select(String content, String selector, String attr) {
        SelectDto selectDto = new SelectDto();
        selectDto.setContent(content);
        selectDto.setSelector(selector);
        selectDto.setAttr(attr);


        ResponseModel<String> responseModel = ResponseModelFactory.FAILED();
        try{
            responseModel = processorFacadeService.select(selectDto);
        }catch (Exception e){
            // 重试
            for (int i = 0; i < TaskConstant.RETRY_TIME; i++) {
                responseModel = processorFacadeService.select(selectDto);
                if (responseModel.isSuccess()) {
                    break;
                }
            }
        }

        return responseModel.getData();
    }

    @Override
    public List<String> regex(String content, String regex, String group) {
        RegexDealDto regexDealDto = new RegexDealDto();
        regexDealDto.setContent(content);
        regexDealDto.setRegexStr(regex);
        regexDealDto.setGroup(group);

        ResponseModel<List<String>> responseModel = ResponseModelFactory.FAILED();
        try{
            responseModel = processorFacadeService.regex(regexDealDto);
        }catch (Exception e){
            // 重试
            for (int i = 0; i < TaskConstant.RETRY_TIME; i++) {
                responseModel = processorFacadeService.regex(regexDealDto);
                if (responseModel.isSuccess()) {
                    break;
                }
            }
        }
        return responseModel.getData();
    }
}
