package com.bxm.spider.manager.integration.prod.service.impl;

import com.bxm.spider.constant.task.TaskConstant;
import com.bxm.spider.download.facade.service.DownloadFeignService;
import com.bxm.spider.manager.integration.prod.service.DownloadIntegrationService;
import com.bxm.spider.response.ResponseModel;
import com.bxm.spider.response.ResponseModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @ClassName DownloadIntegrationServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/2/28 17:37
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/2/28 17:37
 **/
@Service
public class DownloadIntegrationServiceImpl implements DownloadIntegrationService {

    @Autowired
    DownloadFeignService downloadFeignService;

    @Override
    public String pageDownload(String url, boolean isProxy) {
        ResponseModel<String> responseModel = ResponseModelFactory.FAILED();
        try{
            responseModel = downloadFeignService.pageDownload(url,isProxy);
        }catch (Exception e){
            // 重试
            for (int i = 0; i < TaskConstant.RETRY_TIME; i++) {
                responseModel = downloadFeignService.pageDownload(url,isProxy);
                if (responseModel.isSuccess()) {
                    break;
                }
            }
        }
        return responseModel.getData();
    }
}
