package com.bxm.spider.manager.integration.prod.service.impl;

import com.bxm.spider.manager.integration.prod.service.TaskFeignIntegrationService;
import com.bxm.spider.prod.facade.model.dto.TaskDto;
import com.bxm.spider.prod.facade.service.TaskFeignService;
import com.bxm.spider.response.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 任务调度服务实现
 *
 * @ClassName TaskFeignIntegrationServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/18 13:55
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/18 13:55
 **/
@Service
public class TaskFeignIntegrationServiceImpl implements TaskFeignIntegrationService {

    @Autowired
    private TaskFeignService taskFeignService;

    @Override
    public ResponseModel<Boolean> start(TaskDto taskDto) {
        return taskFeignService.start(taskDto);
    }

    @Override
    public ResponseModel<Boolean> pause(TaskDto taskDto) {
        return taskFeignService.pause(taskDto);
    }

    @Override
    public ResponseModel<Boolean> resume(TaskDto taskDto) {
        return taskFeignService.resume(taskDto);
    }

    @Override
    public ResponseModel<Boolean> stop(TaskDto taskDto) {
        return taskFeignService.stop(taskDto);
    }

    @Override
    public ResponseModel<Boolean> restartAll() {
        return taskFeignService.restartAll();
    }
}
