package com.bxm.spider.manager.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 前端配置表
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-16
 */
@Data
@TableName("url_config")
public class UrlConfig implements Serializable {

    private static final long serialVersionUID = 1127129558989540942L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 任务流水号
     */
    @ApiModelProperty("任务流水号")
    private String serialNum;
    /**
     * 目标url
     */
    @ApiModelProperty("目标url")
    private String url;
    /**
     * 是否使用代理 0-否 1-是，默认值0
     */
    @ApiModelProperty("是否使用代理 0-否 1-是，默认值0")
    private Integer proxyFlag;
    @ApiModelProperty("站点类型:1全国内容,2地方内容,3地方测试新闻,4优惠券;21地方招聘,22地方新闻;221地方公众号,222地方网站,223地方app")
    private String siteType;
    /**
     * 网页cookie
     */
    @ApiModelProperty("网页cookie")
    private String cookie;
    /**
     * 网页UserAgent
     */
    @ApiModelProperty("网页UserAgent")
    private String userAgent;
    /**
     * url频道分类描述
     */
    @ApiModelProperty("url频道分类描述")
    private String channelDesc;
    /**
     * 处理器类型 HTML KUAIYINSHI WECHAT
     */
    @ApiModelProperty("处理器类型 HTML KUAIYINSHI WECHAT")
    private String processorType;
    /**
     * 存储类型(NEWS-新闻,WECHAT-公众号,VIDEO-小视频,RECRUIT-招聘)
     */
    @ApiModelProperty("存储类型(NEWS-新闻,WECHAT-公众号,VIDEO-小视频,RECRUIT-招聘)")
    private String persistenceType;
    @ApiModelProperty("地区")
    private String region;
    @ApiModelProperty("地区说明")
    private String regionDesc;
    /**
     * 过滤规则site
     */
    @ApiModelProperty("过滤规则site")
    private String rulerSite;
    /**
     * 请求 referer 参数
     */
    @ApiModelProperty("Referer")
    private String referer;

    /**
     * 频道
     */
    @ApiModelProperty("频道")
    private String channel;
    /**
     * 状态(0-不可用 1-可用)
     */
    @ApiModelProperty("状态(0-不可用 1-可用)")
    private Integer status;
    /**
     * 列表爬取深度
     */
    @ApiModelProperty("列表爬取深度")
    private Integer queueDepth;
    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;
    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    private String createUser;
    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date modifyTime;
    /**
     * 修改人
     */
    @ApiModelProperty("修改人")
    private String modifyUser;
    @ApiModelProperty("下载预处理类型:URL,COOKIE,LOGIN,DOUYIN")
    private String pretreatmentType;
    @ApiModelProperty("下载预处理参数：参数名1@处理方式1&参数名2@处理方式2 (处理方式枚举值：RANDOMSTRING32,TIMESTAMP,DATEFORMAT19)")
    private String pretreatmentParam;
    @ApiModelProperty("编码:UTF-8")
    private String charset;


}
