package com.bxm.spider.manager.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 过滤规则表
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-16
 */
@Data
@TableName("url_ruler")
public class UrlRuler implements Serializable {

    private static final long serialVersionUID = 6632623696443935841L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 站点
     */
    @ApiModelProperty("站点")
    private String site;
    /**
     * 规则详情名称
     */
    @ApiModelProperty("规则详情名称")
    private String name;
    /**
     * 需要匹配的内容
     */
    @ApiModelProperty("需要匹配的内容")
    private String keyword;
    /**
     * 解析出值的前缀(解析一些特殊url时配置)
     */
    @ApiModelProperty("解析出值的前缀(解析一些特殊url时配置)")
    private String prefix;
    /**
     * 替换规则：_:_分割多个需要替换的内容；_=_分割替换体，左边为源内容，右边为替换的新内容
     */
    @ApiModelProperty("替换规则：_:_分割多个需要替换的内容；_=_分割替换体，左边为源内容，右边为替换的新内容")
    private String replacement;
    /**
     * 时间转换格式（多个格式用_:_隔开）
     */
    @ApiModelProperty("时间转换格式（多个格式用_:_隔开）")
    private String timePatter;
    /**
     * 报文分析工具，使用正则式:'REGEX',JSOUP:'JSOUP'
     */
    @ApiModelProperty("报文分析工具，使用正则式:'REGEX',JSOUP:'JSOUP'")
    private String analyticalTools;
    /**
     * html编码转换(1转换，0不转换)
     */
    @ApiModelProperty("html编码转换(1转换，0不转换)")
    private String escapeHtml;
    /**
     * 默认值
     */
    @ApiModelProperty("默认值")
    private String defaultValue;
    /**
     * 下一页参数名称(根据该参数名称的值+1获取下一页的url地址)
     */
    @ApiModelProperty("下一页参数名称(根据该参数名称的值+1获取下一页的url地址)")
    private String nextPagePara;
    /**
     * suffix
     */
    @ApiModelProperty("后缀")
    private String suffix;
    /**
     * 匹配规则
     */
    @ApiModelProperty("匹配规则")
    private String ruler;
    /**
     * 是否非空(0-否 1-是)
     */
    @ApiModelProperty("是否非空(0-否 1-是)")
    private Integer emptyFlag;
    /**
     * 父站点地址
     */
    @ApiModelProperty("父站点地址")
    private String parentSite;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;
    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    private String createUser;
    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date modifyTime;
    /**
     * 修改人
     */
    @ApiModelProperty("修改人")
    private String modifyUser;
    /**
     * 规则类型：1 列表规则(url_);2 详情规则;3 评论规则
     */
    @ApiModelProperty("类型：1 列表规则(url_);2 详情规则;3 评论规则")
    private Short type;


}
