package com.bxm.spider.manager.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 任务表
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-16
 */
@Data
@TableName("url_task")
public class UrlTask implements Serializable {

    private static final long serialVersionUID = -2922830743308209189L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 任务名称
     */
    @ApiModelProperty("任务名称")
    private String name;
    /**
     * 任务流水号
     */
    @ApiModelProperty("任务流水号")
    private String serialNum;
    /**
     * 任务执行周期
     */
    @ApiModelProperty("任务执行周期")
    private String schule;
    /**
     * 列表爬取周期
     */
    @ApiModelProperty("列表爬取周期")
    private String queueSchule;
    /**
     * 列表爬取频率
     */
    @ApiModelProperty("列表爬取频率")
    private Integer queueRate;
    /**
     * 详情爬取周期
     */
    @ApiModelProperty("详情爬取周期")
    private String detailsSchule;
    /**
     * 详情爬取频率
     */
    @ApiModelProperty("详情爬取频率")
    private Integer detailsRate;
    /**
     * 说明
     */
    @ApiModelProperty("说明")
    private String desc;
    /**
     * 最少爬取数量
     */
    @ApiModelProperty("最少爬取数量")
    private Integer minCrawlCount;
    /**
     * 任务运行状态 1-待启动 2-执行中 3-暂停 4-停止
     */
    @ApiModelProperty("任务运行状态 1-待启动 2-执行中 3-暂停 4-停止")
    private Integer executeStatus;
    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;
    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    private String createUser;
    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date modifyTime;
    /**
     * 修改人
     */
    @ApiModelProperty("修改人")
    private String modifyUser;


}
