package com.bxm.spider.manager.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 监控报表传输对象
 *
 * @ClassName SpiderReportDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author stephen
 * @Date 2018/12/21 15:15
 * @Version 1.0
 **/
@Data
public class SpiderMonitorReportDto extends CommonQueryDto {

    @ApiModelProperty("流水号")
    private String serialNum;

    @ApiModelProperty("网站类型：全国内容，地方内容，地方测试新闻，优惠券，地方招聘，地方新闻，地方公众号，地方网站，地方app")
    private String siteType;

    @ApiModelProperty("流程类型：调度 PROD_PROGRESS，下载 DOWNLOAD_PROGRESS，解析列表 DEAL_LIST，解析详情 DEAL_DETAIL，保存 SAVE_PROGRESS，可多选，逗号分隔")
    private String flowCodes;

    private String urlType;

    private List<String> flowCodeList;

}
