package com.bxm.spider.manager.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 任务表
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-16
 */
@Data
public class UrlTaskDto implements Serializable {

    private static final long serialVersionUID = 4577285144823055910L;
    /**
     * 页码
     */
    @ApiModelProperty("页码")
    private Integer pageNum;

    /**
     * 分页长度
     */
    @ApiModelProperty("分页长度")
    private Integer pageSize;

    /**
     * 长度
     */
    @ApiModelProperty("长度")
    private String name;

    /**
     * 流水号
     */
    @ApiModelProperty("流水号")
    private String serialNum;

    /**
     * 频道
     */
    @ApiModelProperty("频道")
    private String channel;

    /**
     * 任务运行状态 1-待启动 2-执行中 3-暂停 4-停止
     */
    @ApiModelProperty("任务运行状态 1-待启动 2-执行中 3-暂停 4-停止")
    private Integer executeStatus;

    @ApiModelProperty("id")
    private Long id;
}
