package com.bxm.spider.manager.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 监控报表
 *
 * @author stephen
 * @since 2018-12-21
 */
@Data
public class SpiderMonitorReportVo {

    @ApiModelProperty("任务流水号")
    private String serialNum;

    @ApiModelProperty("url类型")
    private String urlType;

    @ApiModelProperty("站点名称")
    private String siteName;

    @ApiModelProperty("应用名称")
    private String siteType;

    @ApiModelProperty("站点数")
    private String siteCount;

    @ApiModelProperty("监控时间")
    private String monitorTime;

    @ApiModelProperty("调度开始次数")
    private Integer prodStart;

    @ApiModelProperty("调度结束次数")
    private Integer prodEnd;

    @ApiModelProperty("下载开始次数")
    private Integer downloadStart;

    @ApiModelProperty("下载结束次数")
    private Integer downloadEnd;

    @ApiModelProperty("处理开始次数")
    private Integer dealStart;

    @ApiModelProperty("处理列表次数")
    private Integer dealList;

    @ApiModelProperty("处理详情次数")
    private Integer dealDetail;

    @ApiModelProperty("处理结束次数")
    private Integer dealEnd;

    @ApiModelProperty("保存开始次数")
    private Integer saveStart;

    @ApiModelProperty("保存结束次数")
    private Integer saveEnd;

    @ApiModelProperty("保存插入次数")
    private Integer saveInsert;

    @ApiModelProperty("保存更新次数")
    private Integer saveUpdate;

    @ApiModelProperty("调度成功率")
    private String prodSuccessRate;

    @ApiModelProperty("下载成功率")
    private String downloadSuccessRate;

    @ApiModelProperty("解析成功率")
    private String dealSuccessRate;

    @ApiModelProperty("保存成功率")
    private String saveSuccessRate;
}
