package com.bxm.spider.monitor.service.controller;

import com.alibaba.fastjson.JSON;
import com.bxm.spider.constant.monitor.MonitorLogDto;
import com.bxm.spider.monitor.service.service.MonitorLogService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 监控日志服务
 *
 * @ClassName MonitorLogController
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author stephen
 * @Date 2018/12/19 15:15
 * @Version 1.0
 **/
@RestController
@RequestMapping("/monitorLog")
public class MonitorLogController {

    @Autowired
    private MonitorLogService monitorLogService;

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public ResponseModel<Boolean> save(@RequestParam(value = "data", required = false) String data) {
        if (StringUtils.isBlank(data)) {
            return ResponseModelFactory.SUCCESS(true);
        }

        return ResponseModelFactory.SUCCESS(monitorLogService.saveResult(JSON.parseObject(data, MonitorLogDto.class)));
    }

}
