package com.bxm.spider.monitor.service.controller;

import com.bxm.spider.monitor.facade.model.SpiderExceptionMonitorVo;
import com.bxm.spider.monitor.facade.model.SpiderMonitorReportDto;
import com.bxm.spider.monitor.facade.model.SpiderMonitorReportVo;
import com.bxm.spider.monitor.facade.service.MonitorReportFacadeService;
import com.bxm.spider.monitor.service.service.MonitorReportService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 监控日志报表服务
 *
 * @ClassName MonitorReportController
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author stephen
 * @Date 2018/12/19 15:15
 * @Version 1.0
 **/
@RestController
@RequestMapping("/monitorReport")
public class MonitorReportController implements MonitorReportFacadeService {

    @Autowired
    private MonitorReportService monitorReportService;

    /**
     * 分页查询站点列表
     * @param spiderMonitorReportDto
     * @return
     */
    @Override
    @RequestMapping(value = "/getSitePageList", method = RequestMethod.POST)
    public ResponseModel<PageInfo<SpiderMonitorReportVo>> getSitePageList(@RequestBody SpiderMonitorReportDto spiderMonitorReportDto) {
        return ResponseModelFactory.SUCCESS(monitorReportService.getSitePageList(spiderMonitorReportDto));
    }

    /**
     * 分页查询应用列表
     * @param spiderMonitorReportDto
     * @return
     */
    @Override
    @RequestMapping(value = "/getAppPageList", method = RequestMethod.POST)
    public ResponseModel<PageInfo<SpiderMonitorReportVo>> getAppPageList(@RequestBody SpiderMonitorReportDto spiderMonitorReportDto) {
        return ResponseModelFactory.SUCCESS(monitorReportService.getAppPageList(spiderMonitorReportDto));
    }

    /**
     * 分页查询错误列表
     * @param spiderMonitorReportDto
     * @return
     */
    @Override
    @RequestMapping(value = "/getErrorPageList", method = RequestMethod.POST)
    public ResponseModel<PageInfo<SpiderExceptionMonitorVo>> getErrorPageList(@RequestBody SpiderMonitorReportDto spiderMonitorReportDto) {
        return ResponseModelFactory.SUCCESS(monitorReportService.getErrorPageList(spiderMonitorReportDto));
    }

}
