package com.bxm.spider.monitor.service.service;

import com.bxm.spider.monitor.facade.model.SpiderExceptionMonitorVo;
import com.bxm.spider.monitor.facade.model.SpiderMonitorReportDto;
import com.bxm.spider.monitor.facade.model.SpiderMonitorReportVo;
import com.github.pagehelper.PageInfo;

/**
 * 监控日志报表服务
 *
 * @ClassName MonitorLogService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author stephen
 * @Date 2018/12/19 15:15
 * @Version 1.0
 **/
public interface MonitorReportService {

    /**
     * 分页查询站点列表
     * @param spiderMonitorReportDto
     * @return PageInfo<SpiderMonitorReportVo>
     * @author stephen
     * @date 2018/12/19 15:15
     */
    PageInfo<SpiderMonitorReportVo> getSitePageList(SpiderMonitorReportDto spiderMonitorReportDto);

    /**
     * 分页查询应用列表
     * @param spiderMonitorReportDto
     * @return PageInfo<SpiderMonitorReportVo>
     * @author stephen
     * @date 2018/12/24 15:15
     */
    PageInfo<SpiderMonitorReportVo> getAppPageList(SpiderMonitorReportDto spiderMonitorReportDto);

    /**
     * 分页查询错误列表
     * @param spiderMonitorReportDto
     * @return PageInfo<SpiderExceptionMonitorVo>
     * @author stephen
     * @date 2018/12/24 15:15
     */
    PageInfo<SpiderExceptionMonitorVo> getErrorPageList(SpiderMonitorReportDto spiderMonitorReportDto);

}
