package com.bxm.spider.monitor.service.service.impl;

import com.bxm.spider.monitor.dal.mapper.SpiderExceptionMonitorMapper;
import com.bxm.spider.monitor.dal.mapper.SpiderMonitorReportMapper;
import com.bxm.spider.monitor.facade.model.SpiderExceptionMonitorVo;
import com.bxm.spider.monitor.facade.model.SpiderMonitorReportDto;
import com.bxm.spider.monitor.facade.model.SpiderMonitorReportVo;
import com.bxm.spider.monitor.service.service.MonitorReportService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;

/**
 * 监控日志服务实现
 *
 * @ClassName MonitorLogServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author stephen
 * @Date 2018/12/19 15:15
 * @Version 1.0
 **/
@Service
public class MonitorReportServiceImpl implements MonitorReportService {

    @Autowired
    private SpiderMonitorReportMapper spiderMonitorReportMapper;

    @Autowired
    private SpiderExceptionMonitorMapper spiderExceptionMonitorMapper;

    @Override
    public PageInfo<SpiderMonitorReportVo> getSitePageList(SpiderMonitorReportDto spiderMonitorReportDto) {
        PageHelper.startPage(spiderMonitorReportDto.getPageNum(), spiderMonitorReportDto.getPageSize());

        PageInfo<SpiderMonitorReportVo> resultPage = new PageInfo<>(spiderMonitorReportMapper.getSiteList(spiderMonitorReportDto));
        calExtraColumn(resultPage);

        return resultPage;
    }

    @Override
    public PageInfo<SpiderMonitorReportVo> getAppPageList(SpiderMonitorReportDto spiderMonitorReportDto) {
        PageHelper.startPage(spiderMonitorReportDto.getPageNum(), spiderMonitorReportDto.getPageSize());

        PageInfo<SpiderMonitorReportVo> resultPage = new PageInfo<>(spiderMonitorReportMapper.getAppList(spiderMonitorReportDto));
        calExtraColumn(resultPage);

        return resultPage;
    }

    @Override
    public PageInfo<SpiderExceptionMonitorVo> getErrorPageList(SpiderMonitorReportDto spiderMonitorReportDto) {
        PageHelper.startPage(spiderMonitorReportDto.getPageNum(), spiderMonitorReportDto.getPageSize());
        if (spiderMonitorReportDto != null && StringUtils.isNotBlank(spiderMonitorReportDto.getFlowCodes())) {
            spiderMonitorReportDto.setFlowCodeList(Arrays.asList(spiderMonitorReportDto.getFlowCodes().split(",")));
        }
        return new PageInfo<>(spiderExceptionMonitorMapper.getErrorList(spiderMonitorReportDto));
    }

    private void calExtraColumn(PageInfo<SpiderMonitorReportVo> resultPage) {
        if (CollectionUtils.isNotEmpty(resultPage.getList())) {
            for (SpiderMonitorReportVo spiderMonitorReport : resultPage.getList()) {
                if (spiderMonitorReport.getProdStart() != 0) {
                    spiderMonitorReport.setProdSuccessRate(spiderMonitorReport.getProdEnd() * 100 / spiderMonitorReport.getProdStart() + "%");
                }
                if (spiderMonitorReport.getDownloadStart() != 0) {
                    spiderMonitorReport.setDownloadSuccessRate(spiderMonitorReport.getDownloadEnd() * 100 / spiderMonitorReport.getDownloadStart() + "%");
                }
                if (spiderMonitorReport.getDealStart() != 0) {
                    spiderMonitorReport.setDealSuccessRate(spiderMonitorReport.getDealEnd() * 100 / spiderMonitorReport.getDealStart() + "%");
                }
                if (spiderMonitorReport.getSaveStart() != 0) {
                    spiderMonitorReport.setSaveSuccessRate(spiderMonitorReport.getSaveEnd() * 100 / spiderMonitorReport.getSaveStart() + "%");
                }
            }
        }
    }
}
