package com.bxm.spider.prod.facade;

import com.bxm.spider.prod.facade.fallback.DownloadFallbackFactory;
import com.bxm.spider.prod.param.DownloadParam;
import com.bxm.spider.response.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "download-service", fallbackFactory = DownloadFallbackFactory.class, primary = false)
public interface DownloadFeignService {

    /**
     * 下载
     */
    @PostMapping(value = "/downloader/download")
    ResponseModel<Boolean> download(@RequestBody DownloadParam downloadParam);

    /**
     * 单页下载
     */
    @PostMapping(value = "/downloader/pageDownload")
    ResponseModel<String> pageDownload(@RequestParam("url") String url, @RequestParam("isProxy") boolean isProxy);
}
